""" ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Extract_County Level Range Maps
Description: Breaks up county related polygons and places the
feature classes into seperate dir

Requirements: Python.
This tool has required arguments, and one optional:
 1) an input feature (e.g. counties, hexagons, watersheds) layer name & join field; 2 reqired inputs
 2) a summary table for the cursor (e.g. ESLF code, ESLF_Name, percent_min fields) 2 required inputs, name needs to be present in summary table
 3) List of speces by unit; 2 inputs, table name and join field name
 4) an output workspace (where the results will be written to), must be different than the input workspace
 5) the input workspace where base data is stored.

Author: Jon Hak
NatureServe

Date: 11/14/2012
F:\Projects\ConservationServices\RangeMaps\Draft_Range_Maps.gdb\MJD_STD_County_102012 F:\Projects\ConservationServices\RangeMaps\Draft_Range_Maps.gdb\tblScien_name F:\Projects\ConservationServices\RangeMaps\Draft_Range_Maps.gdb\Test_Range_Subset_V2 "F:\Projects\ConservationServices\RangeMaps\Range Maps Output.gdb" F:\Projects\ConservationServices\RangeMaps\Draft_Range_Maps.gdb
Modified to make inputs multi value capable 12/12/2012
F:\Projects\ConservationServices\RangeMaps\Draft_Range_Maps.gdb\MJD_STD_County_102012 FIPS F:\Projects\ConservationServices\RangeMaps\Draft_Range_Maps.gdb\tblScien_name chrSCIEN_NAME F:\Projects\ConservationServices\RangeMaps\Draft_Range_Maps.gdb\Test_Range_Subset_V2 FIPS "F:\Projects\ConservationServices\RangeMaps\Range Maps OUtputV2.gdb" F:\Projects\ConservationServices\RangeMaps\Draft_Range_Maps.gdb
F:\Projects\RCN_Odonates\US_Only_Test_Ranges.gdb\MJD_STD_County_102012 FIPS F:\Projects\RCN_Odonates\US_Only_Test_Ranges.gdb\US_ONLY_Spp_List NS_SCIENTI F:\Projects\RCN_Odonates\US_Only_Test_Ranges.gdb\US_ONLY_Summarized FIPS F:\Projects\RCN_Odonates\US_Only_Test_Ranges_OUTPUT.gdb F:\Projects\RCN_Odonates\US_Only_Test_Ranges.gdb
D:\Projects\IUCNRedlist\Analysis\IUCN_L48_Range_Inputs.gdb\NAmerica_100Km_hex" "GLOBAL_ID "D:\Projects\IUCNRedlist\Analysis\IUCN_L48_Range_Inputs.gdb\L48_EVT_targets" ESLF "D:\Projects\IUCNRedlist\Analysis\IUCN_L48_Range_Inputs.gdb\L48_v29xHeX" GLOBAL_ID "D:\Projects\IUCNRedlist\Analysis\IUCN_L48_EVT_Range_Maps2.gdb" "D:\Projects\IUCNRedlist\Analysis\IUCN_L48_Range_Inputs.gdb"
D:\Projects\IUCNRedlist\Analysis\SA_Rangemaps_Inputs.gdb\SAmerica_100km_continent" "global_id2" "D:\Projects\IUCNRedlist\Analysis\SA_Rangemaps_Inputs.gdb\lutSAMacroGroups_targets" "SA_ESLF2MG_XCLI_" "MacroGroup" "D:\Projects\IUCNRedlist\Analysis\SA_Rangemaps_Inputs.gdb\tblHex_x_MG_gt2ha_final2" "global_id2" "D:\Projects\IUCNRedList\Analysis\SA_Hex_MG_Rangemaps.gdb" "D:\Projects\IUCNRedlist\Analysis\SA_Rangemaps_Inputs.gdb"
D:\Projects\IUCNRedlist\Analysis\Hawaii_Inputs.gdb\Hawaii_100km Global_ID2 D:\Projects\IUCNRedlist\Analysis\Hawaii_Inputs.gdb\tblEVT_List VALUE CLASSNAME D:\Projects\IUCNRedlist\Analysis\Hawaii_Inputs.gdb\tblHex_x_EVT HEX D:\Projects\IUCNRedlist\Analysis\Hawaii_EVT_RangeMaps.gdb D:\Projects\IUCNRedlist\Analysis\Hawaii_Inputs.gdb

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ """
import arcpy, sys, os, string
from arcpy import env

arcpy.AddToolbox("C:/Program Files (x86)/ArcGIS/Desktop10.6/ArcToolbox/Toolboxes/Data Management Tools.tbx")
arcpy.AddToolbox("C:/Program Files (x86)/ArcGIS/Desktop10.6/ArcToolbox/Toolboxes/Analysis Tools.tbx")

env.overwriteOutput = 1

#Set the input layer (e.g. Hucs, counties, states...)
inFeature = sys.argv[1]
# Must be in File Geodatabase
print inFeature
inFeatureField = sys.argv[2]
print inFeatureField

#Set the cursor table.  A list of unique elements. This field must be present in the combined table.
cursorTable = sys.argv[3]
# Must be in File Geodatabase
print cursorTable
inCursorTableField = sys.argv[4]
print inCursorTableField
outCursorTableName = inCursorTableField
outFeatureName = sys.argv[5]
print outFeatureName

#Set the input Combined table.  The one-to-may table represent the elements presence within a mapping unit.
inList = sys.argv[6]
# Must be in File Geodatabase
print inList
inListField = sys.argv[7]
print inListField

#Set the output workspace for shapefiles or geodatabase
out_Workspace = sys.argv[8]
# Must be in File Geodatabase
print out_Workspace

# Set the input workspace geodatabase containing relate tables, change later to pull path from inFeature line
in_Workspace = sys.argv[9]
# Must be in File Geodatabase
print in_Workspace

#Set Start Time
start_time = time.time()

GP = None
#logfile = open(fin_cond_dir + os.sep + "Hex_log.txt", "a+")
logfile = open("c:/temp/jch/Hex_log.txt", "a+")
def log(x, error=False):
  logfile.write(x)
  logfile.write("\n")
  logfile.flush()
  print(x)
  if (GP != None):
    if (error):
      arcpy.AddError(x)
    else:
      arcpy.AddMessage(x)

try:
    env.workspace = out_Workspace
    env.qualifiedFieldNames = "UNQUALIFIED"
    Targets_lyr = "Targets_lyr"
    arcpy.MakeFeatureLayer_management(inFeature, Targets_lyr)
    counter = 0
    cnt = 0
    # Use Cursors to step through a list of unique elements to be mapped.
    rows = arcpy.SearchCursor(cursorTable)
    fields = arcpy.ListFields(cursorTable)

    for row in rows:
        count = 0
        inputField = row.getValue(inCursorTableField)
        #print inputField
        outField = row.getValue(outCursorTableName)
        #inFilter = row.getValue("Filter") #Problem?
        inFilter = 1
        #print outField
        outName = row.getValue(outFeatureName)
        #print outName
        arcpy.AddMessage("Processing - " + outName)
        el_row = inputField
        Target_row = el_row
        #select = "\"" + inCursorTableField + "\" = " + "'" + el_row + "'" # + "AND" + "\"PERCENT\" >= " + min_rowt
        if inFilter == 1:
            select = "\"" + inCursorTableField + "\" = " + str(el_row)
        else:
            select = "\"" + inCursorTableField + "\" = " + str(el_row) + " AND " + "\"HA\" >= 100" # 100ha or greater for hex in current extent
        #print select
        outList = in_Workspace + "/" + "lstTemp"
        #outList = "D:/Projects/IUCNRedlist/Analysis/MesoAm_Inputs.gdb/lstTemp"
        #arcpy.MakeTableView_management(inList, inList2)
        arcpy.TableSelect_analysis(inList, outList, select)
        count1 = -99
        count1 = arcpy.GetCount_management(outList)
        #print "Records Selected = " + str(count1)
        arcpy.AddJoin_management(Targets_lyr, inFeatureField, outList, inListField, "KEEP_COMMON")
        counter = -99
        count = arcpy.GetCount_management(Targets_lyr)
        counter = int(count.getOutput(0))
        log(outName + " - " + str(el_row) + " = " + str(counter))
        if counter >= int(1):
            outShape = out_Workspace + "/" + arcpy.ValidateTableName(outName)
            print "Records Selected = " + str(counter) + " - " + outShape
            arcpy.CopyFeatures_management(Targets_lyr, outShape)
            # arcpy.AddField_management(outShape, "Action", "SHORT", "", "", 25)
            arcpy.AddField_management(outShape, "Change2", "LONG", "", "", 100)
            arcpy.AddField_management(outShape, "Comment", "TEXT", "", "", 255)
            dropFields = ["OBJECTID_1", "GLOBAL_ID2_1", "VALUE"]
            arcpy.DeleteField_management(outShape, dropFields)
            # inFeatures = "Africa.DBO.MG_POINT_SEPT23_TB_MERGED_ALB_Combined"
            # arcpy.SetSubtypeField_management("Africa.DBO.MG_POINT_SEPT23_TB_MERGED_ALB_Combined", "From_ESLF")
            #domName = "MacroGroup"
            #inField = "MG_Code"
            # arcpy.SetSubtypeField_management(outShape, "Change2")
            # arcpy.AddSubtype_management(outShape,"1","Delete")
            # arcpy.AddSubtype_management(outShape,"2","Modify")
            arcpy.AddMessage("Output - " + outName)
            arcpy.RemoveJoin_management(Targets_lyr, "lstTemp")
            counter = -99
            cnt = cnt + 1
        else:
            #select = "\"" + inCursorTableField + "\" = " + str(el_row)
            #arcpy.TableSelect_analysis(inList, outList, select)
            #arcpy.AddJoin_management(Targets_lyr, inFeatureField, outList, inListField, "KEEP_COMMON")
            #outShape = out_Workspace + "/" + arcpy.ValidateTableName(outName) + "_lt100ha"
            #print outShape
            #arcpy.CopyFeatures_management(Targets_lyr, outShape)
            #arcpy.AddField_management(outShape, "Change2", "LONG", "", "", 100)
            #arcpy.AddField_management(outShape, "Comment", "TEXT", "", "", 255)
            #domName = "MacroGroup"
            #inField = "MG_Code"
            #arcpy.AddMessage("Output - " + outName)
            print "Records Selected = " + str(counter) + " - " + outShape
            arcpy.RemoveJoin_management(Targets_lyr, "lstTemp")
            counter = -99
            cnt = cnt + 1


except:
    arcpy.AddMessage(arcpy.GetMessages(2))
    print arcpy.GetMessages(2)

elapsed_time = (time.time() - start_time) / 3600
print "Model Complete: " + str(cnt) + " Processes in (hr.min) - " + str(elapsed_time)



