'''
/***************************************************************************
Name		         : Constants
Description          : Constant variables used by Fire Mapping Tool
 ***************************************************************************/
'''

import numpy as np
import os

VERSION = "Version 2"
GUI_TITLE = f"Fire Mapping Tool - {VERSION}"

RAW_DIR = "raw"
SRC_DIR = "img_src"
TEMPLATES_DIR = "templates"
SUN_EARTH_DIST_FILE = os.path.join(TEMPLATES_DIR, "SunEarthDistance.txt")

TARGZ_EXT = '.tar.gz'
TAR_EXT = '.tar'
ZIP_EXT = '.zip'

# full sensor list
SENSOR_LIST = ['s2b','s2a','lt04','lt05','le07','lc08','lc09','lo09']

S_EXO = {}
S_EXO['lt04'] = {}
S_EXO['lt05'] = {}
S_EXO['le07'] = {}

S_EXO['lt04'][1] = 1983.0
S_EXO['lt04'][2] = 1795.0
S_EXO['lt04'][3] = 1539.0
S_EXO['lt04'][4] = 1028.0
S_EXO['lt04'][5] = 219.8
S_EXO['lt04'][6] = 83.49

S_EXO['lt05'][1] = 1983.0
S_EXO['lt05'][2] = 1796.0
S_EXO['lt05'][3] = 1536.0
S_EXO['lt05'][4] = 1031.0
S_EXO['lt05'][5] = 220.0
S_EXO['lt05'][6] = 83.44

S_EXO['le07'][1] = 1997.0
S_EXO['le07'][2] = 1812.0
S_EXO['le07'][3] = 1533.0
S_EXO['le07'][4] = 1039.0
S_EXO['le07'][5] = 230.8
S_EXO['le07'][6] = 84.9

NBR_BANDS = {}
NBR_BANDS['sentinel2'] = {}
NBR_BANDS['sentinel2']['s2b'] = {}
NBR_BANDS['sentinel2']['s2a'] = {}
NBR_BANDS['sentinel2']['s2a']['swir'] = 6
NBR_BANDS['sentinel2']['s2a']['nir'] = 4
NBR_BANDS['sentinel2']['s2b']['swir'] = 6
NBR_BANDS['sentinel2']['s2b']['nir'] = 4

NBR_BANDS['landsat'] = {}
NBR_BANDS['landsat']['lc09'] = {}
NBR_BANDS['landsat']['lo09'] = {}
NBR_BANDS['landsat']['lc08'] = {}
NBR_BANDS['landsat']['le07'] = {}
NBR_BANDS['landsat']['lt05'] = {}
NBR_BANDS['landsat']['lt04'] = {}
NBR_BANDS['landsat']['lc09']['swir'] = 7
NBR_BANDS['landsat']['lc09']['nir'] = 5
NBR_BANDS['landsat']['lo09']['swir'] = 7
NBR_BANDS['landsat']['lo09']['nir'] = 5
NBR_BANDS['landsat']['lc08']['swir'] = 7
NBR_BANDS['landsat']['lc08']['nir'] = 5
NBR_BANDS['landsat']['le07']['swir'] = 6
NBR_BANDS['landsat']['le07']['nir'] = 4
NBR_BANDS['landsat']['lt05']['swir'] = 6
NBR_BANDS['landsat']['lt05']['nir'] = 4
NBR_BANDS['landsat']['lt04']['swir'] = 6
NBR_BANDS['landsat']['lt04']['nir'] = 4

PROJ_STRINGS = {}
PROJ_STRINGS['CONUS'] = 'PROJCS["Albers Conical Equal Area",GEOGCS["NAD83",DATUM["North_American_Datum_1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9108"]],AUTHORITY["EPSG","4269"]],PROJECTION["Albers_Conic_Equal_Area"],PARAMETER["standard_parallel_1",29.5],PARAMETER["standard_parallel_2",45.5],PARAMETER["latitude_of_center",23],PARAMETER["longitude_of_center",-96],PARAMETER["false_easting",0],PARAMETER["false_northing",0],UNIT["meters",1]]'
PROJ_STRINGS['Alaska'] = 'PROJCS["WGS_1984_Albers",GEOGCS["WGS 84",DATUM["WGS_1984",SPHEROID["WGS 84",6378137,298.257223563,AUTHORITY["EPSG","7030"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6326"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9108"]],AUTHORITY["EPSG","4326"]],PROJECTION["Albers_Conic_Equal_Area"],PARAMETER["standard_parallel_1",55],PARAMETER["standard_parallel_2",65],PARAMETER["latitude_of_center",50],PARAMETER["longitude_of_center",-154],PARAMETER["false_easting",0],PARAMETER["false_northing",0],UNIT["meters",1]]'
PROJ_STRINGS['Hawaii'] = 'PROJCS["Albers Conical Equal Area",GEOGCS["WGS 84",DATUM["WGS_1984",SPHEROID["WGS 84",6378137,298.257223563,AUTHORITY["EPSG","7030"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6326"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9108"]],AUTHORITY["EPSG","4326"]],PROJECTION["Albers_Conic_Equal_Area"],PARAMETER["standard_parallel_1",8.000000000000002],PARAMETER["standard_parallel_2",18],PARAMETER["latitude_of_center",3],PARAMETER["longitude_of_center",-157],PARAMETER["false_easting",0],PARAMETER["false_northing",0],UNIT["meters",1]]'
PROJ_STRINGS['Puerto Rico'] = 'PROJCS["Albers Conical Equal Area",GEOGCS["NAD83",DATUM["North_American_Datum_1983",SPHEROID["GRS 1980",6378137,298.257222101,AUTHORITY["EPSG","7019"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY["EPSG","6269"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9108"]],AUTHORITY["EPSG","4269"]],PROJECTION["Albers_Conic_Equal_Area"],PARAMETER["standard_parallel_1",29.5],PARAMETER["standard_parallel_2",45.5],PARAMETER["latitude_of_center",23],PARAMETER["longitude_of_center",-96],PARAMETER["false_easting",0],PARAMETER["false_northing",0],UNIT["meters",1]]'

NLCD_COORD = {}
NLCD_COORD['CONUS'] = {}
NLCD_COORD['CONUS']['ulx'] = -2493030-15
NLCD_COORD['CONUS']['uly'] = 3309990+15
NLCD_COORD['CONUS']['lrx'] = 2342640+15
NLCD_COORD['CONUS']['lry'] = 177300-15
NLCD_COORD['Alaska'] = {}
NLCD_COORD['Alaska']['ulx'] = -2232330-15
NLCD_COORD['Alaska']['uly'] = 2380110+15
NLCD_COORD['Alaska']['lrx'] = 1494720+15
NLCD_COORD['Alaska']['lry'] = 344820-15
NLCD_COORD['Hawaii'] = {}
NLCD_COORD['Hawaii']['ulx'] = -345930-15
NLCD_COORD['Hawaii']['uly'] = 2132400+15
NLCD_COORD['Hawaii']['lrx'] = 237210+15
NLCD_COORD['Hawaii']['lry'] = 1753890-15
NLCD_COORD['Puerto Rico'] = {}
NLCD_COORD['Puerto Rico']['ulx'] = 3092430-15
NLCD_COORD['Puerto Rico']['uly'] = 59400+15
NLCD_COORD['Puerto Rico']['lrx'] = 3345210+15
NLCD_COORD['Puerto Rico']['lry'] = -78960-15

# landsat constants
LANDSAT = "landsat"

L1T = True
L1Gt = False
L1G = False
LANDSAT_DTYPES = {'L1T': L1T, 'L1Gt': L1Gt, 'L1G': L1G}

LANDSAT_BANDS = {
    'lt04' : ['B1','B2','B3','B4','B5','B7'],
    'lt05' : ['B1','B2','B3','B4','B5','B7'],
    'le07' : ['B1','B2','B3','B4','B5','B7'],
    'lc08' : ['B1','B2','B3','B4','B5','B6','B7','B9'],
    'lc09' : ['B1','B2','B3','B4','B5','B6','B7','B9'],
    'lo09' : ['B1','B2','B3','B4','B5','B6','B7','B9'],
}

FOCAL_WINDOW_41x41 = np.array([[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
                               [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
                               [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
                               [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
                               [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
                               [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
                               [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
                               [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
                               [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
                               [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
                               [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
                               [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
                               [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
                               [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
                               [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
                               [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
                               [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
                               [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
                               [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
                               [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
                               [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
                               [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
                               [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
                               [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
                               [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
                               [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
                               [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
                               [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
                               [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
                               [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
                               [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
                               [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
                               [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
                               [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
                               [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
                               [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
                               [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
                               [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
                               [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
                               [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
                               [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]])

# sentinel constants
SENTINEL2 = "sentinel2"
SENTINEL2_BANDS = {
    's2a' : ['B02','B03','B04','B08','B8A','B11','B12'],
    's2b' : ['B02','B03','B04','B08','B8A','B11','B12'],
    10.0 : ['B02','B03','B04','B08'],
    20.0 : ['B02','B03','B04','B8A','B11','B12'],
    30.0 : ['B02','B03','B04','B8A','B11','B12'],
    60.0 : ['B02','B03','B04','B8A','B11','B12'],
}

# Landsat sensors will be index 0 through 3
SENSOR_ARRAY = [['5', 'l5', 'L5Style.qml'],
                ['7', 'l7', 'L7Style.qml'],
                ['8', 'l8', 'L8Style.qml'],
                ['9', 'l9', 'L9Style.qml'],
                ['A', 's2a', 'S2AStyle.qml'],
                ['B', 's2b', 'S2BStyle.qml']]

TIF_EXT = '.tif'
NBR = 'NBR'
REFL = 'REFL'
UTM = 'UTM'
GM = 'GM'
GAP_MASK = 'gapmask'
