'''
/***************************************************************************
Name		     : FireParams
Description          :  Fire Params functions for QGIS FMT3 Plugin
copyright            : (C) 2018 by Cheryl Holen
Created              : Sep 10, 2018 - Adapted from QGIS 2.x version
Updated              :
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
'''

from .Ui_FireParams import Ui_FireParams

from PyQt5.QtWidgets import QDialog, QMessageBox


class FireParams(QDialog):
    def __init__(self, scene_dir):
        QDialog.__init__(self)
        self.ui = Ui_FireParams()
        self.ui.setupUi(self)

        self.latitude = 0.0
        self.longitude = 0.0
        self.start_date = ''
        self.end_date = ''

        self.ui.beginCalendarWidget.clicked.connect(self.get_dates)
        self.ui.endCalendarWidget.clicked.connect(self.get_dates)
        self.ui.okButton.clicked.connect(self.setup_fire_data_search)
        self.ui.groupBox.setEnabled(True)

    def get_dates(self):
        ''' Get start date parameters '''
        start_date_temp = self.ui.beginCalendarWidget.selectedDate()
        end_date_temp = self.ui.endCalendarWidget.selectedDate()
        start_year = start_date_temp.year()
        start_month = start_date_temp.month()
        start_day = start_date_temp.day()
        end_year = end_date_temp.year()
        end_month = end_date_temp.month()
        end_day = end_date_temp.day()
        self.start_date = (str(start_year) + '-' +
                           str(start_month).zfill(2) + '-' +
                           str(start_day).zfill(2))
        self.end_date = (str(end_year) + '-' +
                         str(end_month).zfill(2) + '-' +
                         str(end_day).zfill(2))

        return

    def setup_fire_data_search(self):
        ''' Get fire data parameters '''
        if self.start_date < self.end_date:
            self.latitude = self.ui.latSpinBox.value()
            self.longitude = self.ui.longSpinBox.value()
            self.close()
        else:
            QMessageBox.information(None,
                                    u'Error - Date mismatch',
                                    u'End date is earlier than start date',
                                    QMessageBox.Ok)
