"""
/***************************************************************************
Name		     : FMT3 Plugin
Description          : FMT3 Plugin
copyright            : (C) 2018 by Cheryl Holen
Created              : Aug 28, 2018 - Adapted from QGIS 2.x version
Updated              :
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
# Import the PyQt and QGIS libraries
from PyQt5.QtGui import QIcon
from PyQt5.QtWidgets import QMenu, QAction

# Import the code for the dialog
from .FireMappingToolWindow import FireMappingToolWindow
import os.path


class FMT3:

    def __init__(self, iface):
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)

    def initGui(self):
        # Create action that will start plugin configuration
        self.act = QAction(QIcon(
            ":/plugins/fmt3/FMT.png"), u"FMT3", self.iface.mainWindow())
        self.act.pyqtConfigure(triggered=self.event_tool)

        act2 = QAction(u"Fire Mapping Tool", self.iface.mainWindow())
        act2.pyqtConfigure(triggered=self.event_tool)

        self.menu = QMenu("FMT3")
        self.menu.addAction(act2)
        self.iface.mainWindow().menuBar().insertMenu(
                self.iface.firstRightStandardMenu().menuAction(), self.menu)

    def unload(self):
        # Remove the plugin menu item and icon
        self.iface.removeToolBarIcon(self.act)
        self.menu.deleteLater()

    # run method that performs all the real work
    def event_tool(self):
        self.mainWindow = FireMappingToolWindow()
        self.mainWindow.show()
