

import config

import scripts_m2m_download as m2m
import phase1_st_stats_forHua_optimized_level3 as step1
import phase1_merge_batch_forHua as step2
import os

import numpy as np
import psutil
from scipy import stats
import utility_functions as utility_functions
from joblib import Parallel, delayed
import os
import gdal
import time
import datetime as dt

import trends_calculation as trends_calculation


"""
notes from saeed
so the first date in the tileID are the date of Landsat data acquisition and the second date is the processing date of ARD
LE07_CU_011007_20180211_20200615_C01_V1
The bold one is what you need when trying to find tiles for a specific year
"""

if __name__ == '__main__':
    username = config.USERNAME
    password = config.PASSWORD

    #base_dir = "/caldera/projects/usgs/eros/urban_heat_islands/atlanta"
    #base_dir = "C:\\Users\\rhussain\\Desktop\\LSRD\\data\\atlanta_m2m"
    base_dir = "C:\\Users\\rhussain\\Desktop\\pycharm_project_data\\urban-heat-islands\\atlanta_m2m"


    #iata_location_identifier = "ATL"
    #a_start_year_inclusive = 1984
    #a_end_year_inclusive = 1988
    #tile_hv_names_to_match = ["H23V13", "H23V14"]

    #iata_location_identifier = "ATL"
    #a_start_year_inclusive = 1984
    #a_end_year_inclusive = 2019
    #tile_hv_names_to_match = ["H23V13", "H23V14", "H24V13", "H24V14"]

    iata_location_identifier = "IAH"
    a_start_year_inclusive = 1984
    a_end_year_inclusive = 1986
    #a_end_year_inclusive = 2019
    tile_hv_names_to_match = ["H17V17"]




    if not os.path.isdir(base_dir):
        os.mkdir(base_dir)

    '''
    #use this to download data
    for a_tile_hv_name in tile_hv_names_to_match:
        some_h = int(a_tile_hv_name[1:3])
        some_v = int(a_tile_hv_name[4:6])
        destination_folder = base_dir+"/"+a_tile_hv_name
        if not os.path.isdir(destination_folder):
            os.mkdir(destination_folder)
        for current_year in range(a_start_year_inclusive,a_end_year_inclusive+1):
            acq_date = str(current_year)+"-1-1,"+str(current_year)+"-12-31"
            #m2m times out if you use more than 1 thread fyi
            m2m.download_files(directory=destination_folder, h=some_h, v=some_v,acq_date=acq_date,threads=1,username=username,password=password, dataset="ARD_TILE",
                        products="ST")
    '''

    #use this to process data
    work_path = base_dir
    HV_List = tile_hv_names_to_match
    #step1.st_stats_forHua(work_path,HV_List,a_start_year_inclusive,a_end_year_inclusive)
    #step2.merge_batch_forHua(work_path,HV_List,a_start_year_inclusive,a_end_year_inclusive,iata_location_identifier)
    def st_stats_forHua(workpath, HV_List, start_year_inclusive, end_year_inclusive):

        # workpath = r'C:\QZhou\Therm_ARD'
        # workpath = r'S:\Temp\Shi\Impervious_surface\UHI\data\siouxfalls'
        # workpath = "C:\\Users\\rhussain\\Desktop\\LSRD\\data\\phoenix"
        # workpath = "C:\\Users\\rhussain\\Desktop\\LSRD\\data\\phoenix_dev"

        # official
        # workpath = "C:\\Users\\rhussain\\Desktop\\LSRD\\data\\atlanta"
        # HV_List = ["H23V13", "H23V14", "H24V13", "H24V14"]

        # test
        # workpath = "/caldera/projects/usgs/eros/urban_heat_islands/atlanta"
        # HV_List = ["H23V13"]

        # 'H06V13' #['H06V13','H07V13']
        # workpath = r'/lcmap_data/bulk/Qiang/ST_ARD_mn'
        # HV = 'H16V06'

        start_year_inclusive = int(start_year_inclusive)
        end_year_inclusive = int(end_year_inclusive)

        for HV in HV_List:
            # unzips the tar files to the tile folder
            #step1.extract_ST(workpath, HV)

            # converts the files into {}_MeanT_{}.tif, MedianT, maxT, minT files
            # for each year
            processing_year_label = dt.datetime.today().strftime('%Y%m%d')
            step1.ST_annual_stats(workpath, HV, iata_location_identifier, start_year_inclusive, end_year_inclusive,
                            processing_year_label)
            #step1.ST_annual_stats(workpath, HV,iata_location_identifier, start_year_inclusive, end_year_inclusive)

            # converts the files into MeanT,MedianT,maxT,minT for
            # these groups of months [1,2,3][4,5,6][7,8,9][10,11,12]
            #step1.ST_seasonal_stats(workpath, HV,iata_location_identifier, start_year_inclusive, end_year_inclusive)


            #print("starting trend_stats")
            #start_time = time.time()
            #trends_calculation.trend_stats(workpath, HV,"IAH", 'MEANLST', start_year_inclusive, end_year_inclusive)
            #end_time = time.time()
            #print("time taken " + str(end_time - start_time))

    st_stats_forHua(work_path,HV_List,a_start_year_inclusive,a_end_year_inclusive)
    step2.merge_batch_forHua(work_path,HV_List,a_start_year_inclusive,a_end_year_inclusive,iata_location_identifier)


