import trends_calculation
import argparse
import os
import utility_functions
import gdal


def trend_stats_generic(inputdir,outputdir):



    files = os.listdir(inputdir)
    file_path_list = []
    for filename in files:
        file_path_list.append(inputdir+"\\"+filename)

    print(file_path_list)


    ABC = None
    print('file list: ', file_path_list[0])
    (data_annual, data_slope, data_rvalue, data_pvalue, t_res, dim, trans,
     prj) = trends_calculation.get_stats_for_3d_raster_stack_from_file_list(file_path_list)
    print('Exporting!')

    t_res, y_res, x_res = data_annual.shape
    dim = [x_res, y_res, 1]
    utility_functions.saveGeoTiff(
        os.path.join(outputdir, 'Slope.tif'),
        data_slope, dim, trans, prj, dtype=gdal.GDT_Float32)
    utility_functions.saveGeoTiff(
        os.path.join(outputdir, 'pValue.tif'),
        data_pvalue, dim, trans, prj, dtype=gdal.GDT_Float32)
    utility_functions.saveGeoTiff(
        os.path.join(outputdir, 'r-squared.tif'),
        data_rvalue ** 2, dim, trans, prj, dtype=gdal.GDT_Float32)


'''
# https://stackabuse.com/command-line-arguments-in-python/
parser = argparse.ArgumentParser()
# (workpath,HV_List,start_year_inclusive,end_year_inclusive)
parser.add_argument("--workpath", "-w", help="specify workpath directory")
parser.add_argument("--hv_tilename", "-t", help="specify tilename singular")
parser.add_argument("--start_year_inclusive", "-s", help="specify start_year_inclusive")
parser.add_argument("--end_year_inclusive", "-e", help="specify end_year_inclusive")

# Read arguments from the command line
args = parser.parse_args()

if args.workpath and args.hv_tilename and args.start_year_inclusive and args.end_year_inclusive:
    print(str(args))
    trend_stats_generic.trend_stats(workpath, HV, group_name, start_year_inclusive, end_year_inclusive)
'''

#input_folder = r"C:\Users\rhussain\Desktop\pycharm_project_data\urban-heat-islands\atlanta_m2m\standalone_test\MaxSeason2Input"
#output_folder = r"C:\Users\rhussain\Desktop\pycharm_project_data\urban-heat-islands\atlanta_m2m\standalone_test\MaxSeason2Output"

input_folder = r"\\igskmncnfs016.cr.usgs.gov\lsrdfs1\UHI\model\data_test"
output_folder = r"C:\Users\rhussain\Desktop\pycharm_project_data\urban-heat-islands\atlanta_m2m\standalone_test\MaxSeason2Output"

trend_stats_generic(input_folder,output_folder)