
import config

import phase1_st_stats_forHua_optimized_level3 as step1
import phase1_merge_batch_forHua as step2
import os
import re

import subprocess
import time


"""
notes from saeed
so the first date in the tileID are the date of Landsat data acquisition and the second date is the processing date of ARD
LE07_CU_011007_20180211_20200615_C01_V1
The bold one is what you need when trying to find tiles for a specific year
"""

if __name__ == '__main__':
    username = config.USERNAME
    password = config.PASSWORD

    # base_dir = "/caldera/projects/usgs/eros/urban_heat_islands/atlanta"
    # base_dir = "C:\\Users\\rhussain\\Desktop\\LSRD\\data\\atlanta_m2m"

    '''
    iata_location_identifier = "ATL"
    a_start_year_inclusive = 1984
    a_end_year_inclusive = 1985
    tile_hv_names_to_match = ["H23V13", "H23V14"]
    '''

    # atlanta
    #base_dir = "/caldera/projects/usgs/eros/urban_heat_islands/atlanta_10k"
    #iata_location_identifier = "ATL"
    #a_start_year_inclusive = 1984
    #a_end_year_inclusive = 2019
    #tile_hv_names_to_match = ["H23V13", "H23V14", "H24V13", "H24V14"]

    # phoenix
    #base_dir = "/caldera/projects/usgs/eros/urban_heat_islands/phoenix_10k"
    #iata_location_identifier = "PHX"
    #a_start_year_inclusive = 1984
    #a_end_year_inclusive = 2019
    #tile_hv_names_to_match = ["H06V13", "H07V13"]

    # houston
    # base_dir = "/caldera/projects/usgs/eros/urban_heat_islands/houston"
    # iata_location_identifier = "IAH"
    # a_start_year_inclusive = 1984
    # a_end_year_inclusive = 2019
    # tile_hv_names_to_match = ["H17V16", "H17V17"]

    # base_dir = "/caldera/projects/usgs/eros/urban_heat_islands/houston"
    # iata_location_identifier = "IAH"
    # a_start_year_inclusive = 2012
    # a_end_year_inclusive = 2014
    # tile_hv_names_to_match = ["H17V16"]

    base_dir = "/caldera/projects/usgs/eros/urban_heat_islands/SiouxFalls_10k"
    iata_location_identifier = "FSD"
    a_start_year_inclusive = 1984
    a_end_year_inclusive = 2020
    tile_hv_names_to_match = ["H16V06"]

    #base_dir = "/caldera/projects/usgs/eros/urban_heat_islands/minneapolis_10k"
    #iata_location_identifier = "MSP"
    #a_start_year_inclusive = 1984
    #a_end_year_inclusive = 2019
    #tile_hv_names_to_match = ["H18V05","H18V06"]

    '''
    base_dir = "/caldera/projects/usgs/eros/urban_heat_islands/houston"
    iata_location_identifier = "IAH"
    a_start_year_inclusive = 1984
    a_end_year_inclusive = 2019
    tile_hv_names_to_match = ["H17V16", "H17V17"]
    '''

    '''
    base_dir = "/caldera/projects/usgs/eros/urban_heat_islands/houston"
    iata_location_identifier = "IAH"
    a_start_year_inclusive = 1984
    a_end_year_inclusive = 2019
    tile_hv_names_to_match = ["H17V16", "H17V17"]
    '''

    #base_dir = "/caldera/projects/usgs/eros/urban_heat_islands/houston_new_m2m"
    #iata_location_identifier = "IAH"
    #a_start_year_inclusive = 1984
    #a_end_year_inclusive = 2019
    #tile_hv_names_to_match = ["H17V16", "H17V17"]

    
    #base_dir = "/caldera/projects/usgs/eros/urban_heat_islands/no_uncertainty"
    #iata_location_identifier = "IAH"
    #a_start_year_inclusive = 1984
    #a_end_year_inclusive = 2019
    #tile_hv_names_to_match = ["H17V16","H17V17"]

    a_start_year_inclusive = 1984
    a_end_year_inclusive = 2020

    downloads = [
        #("/caldera/projects/usgs/eros/urban_heat_islands/Cheyenne",["H12V08"],"CYS"),
        #("/caldera/projects/usgs/eros/urban_heat_islands/Missoula",["H07V03","H08V03"],"MSO"),
        #("/caldera/projects/usgs/eros/urban_heat_islands/Fargo",["H16V04"],"FAR"),
        #("/caldera/projects/usgs/eros/urban_heat_islands/SiouxFalls",["H16V06"],"FSD"),
        #("/caldera/projects/usgs/eros/urban_heat_islands/LittleRock",["H19V13"],"LIT"),
        #("/caldera/projects/usgs/eros/urban_heat_islands/Birmingham",["H22V13","H22V14"],"BHX"),
        #("/caldera/projects/usgs/eros/urban_heat_islands/DesMoines",["H18V08"],"DSM"),
        #("/caldera/projects/usgs/eros/urban_heat_islands/Boise",["H06V05"],"BOI"),
        #("/caldera/projects/usgs/eros/urban_heat_islands/Pittsburgh",["H25V08","H26V08"],"PIT"),
        #("/caldera/projects/usgs/eros/urban_heat_islands/Louisville",["H22V10","H23V10"],"SDF"),
        #("/caldera/projects/usgs/eros/urban_heat_islands/NewOrleans",["H20V16","H20V17","H21V16","H21V17"],"MSY"),
        #("/caldera/projects/usgs/eros/urban_heat_islands/Minneapolis",["H18V05","H18V06"],"MSP"),
        
        #("/caldera/projects/usgs/eros/urban_heat_islands/Omaha",["H16V08","H17V08"],"OMA"),
        #("/caldera/projects/usgs/eros/urban_heat_islands/Miami",["H27V18","H27V19"],"MIA"),
        #("/caldera/projects/usgs/eros/urban_heat_islands/Raleigh",["H27V11"],"RDU"),
        #("/caldera/projects/usgs/eros/urban_heat_islands/Atlanta",["H23V13","H23V14","H24V13","H24V14"],"ATL"),
        #("/caldera/projects/usgs/eros/urban_heat_islands/Albuquerque",["H10V12","H10V13"],"ABQ"),
        #("/caldera/projects/usgs/eros/urban_heat_islands/Milwaukee",["H21V06","H21V07"],"MKE"),
        #("/caldera/projects/usgs/eros/urban_heat_islands/Baltimore",["H27V08","H27V09","H28V08","H28V09"],"BWI"),
        
        #("/caldera/projects/usgs/eros/urban_heat_islands/LasVegas",["H05V11"],"LAS"),
        #("/caldera/projects/usgs/eros/urban_heat_islands/Detroit",["H23V06","H24V06","H23V07","H24V07"],"DTW"),
        #("/caldera/projects/usgs/eros/urban_heat_islands/Boston",["H30V05","H30V06"],"BOS"),
        #("/caldera/projects/usgs/eros/urban_heat_islands/OklahomaCity",["H16V12","H16V13"],"OKC"),
        #("/caldera/projects/usgs/eros/urban_heat_islands/Memphis",["H20V12","H20V13"],"MEM"),
        #("/caldera/projects/usgs/eros/urban_heat_islands/Nashville",["H22V11","H22V12"],"BNA"),
        #("/caldera/projects/usgs/eros/urban_heat_islands/ElPaso",["H10V15"],"ELP"),
        #("/caldera/projects/usgs/eros/urban_heat_islands/Denver",["H11V09","H12V09"],"DEN"),
        #("/caldera/projects/usgs/eros/urban_heat_islands/Indianapolis",["H22V09"],"IND"),
        #("/caldera/projects/usgs/eros/urban_heat_islands/SanFrancisco",["H01V08","H01V09","H02V08","H02V09"],"SFO"),
        #("/caldera/projects/usgs/eros/urban_heat_islands/Columbus",["H24V08","H24V09"],"CMH"),
        #("/caldera/projects/usgs/eros/urban_heat_islands/Jacksonville",["H26V15","H26V16"],"JAX"),
        #("/caldera/projects/usgs/eros/urban_heat_islands/Dallas",["H16V14","H16V15"],"DFW"),
        #("/caldera/projects/usgs/eros/urban_heat_islands/SanAntonio",["H15V17"],"SAT"),
        #("/caldera/projects/usgs/eros/urban_heat_islands/Philadelphia",["H28V07","H28V08","H29V08"],"PHL")
        #("/caldera/projects/usgs/eros/urban_heat_islands/Houston",["H17V16","H17V17"],"IAH"),
        #("/caldera/projects/usgs/eros/urban_heat_islands/Chicago",["H21V07","H21V08","H22V08"],"ORD"),
        #("/caldera/projects/usgs/eros/urban_heat_islands/LosAngeles",["H03V12","H04V12"],"LAX"),

        #("/caldera/projects/usgs/eros/urban_heat_islands/NewYork",["H28V07","H29V06","H29V07","H29V08"],"LGA")

    ]



    dependency_string = None

    for (base_dir,tile_hv_names_to_match,iata_location_identifier) in downloads:

        if not os.path.isdir(base_dir):
            os.mkdir(base_dir)

        # -------------------------------------------------------------------------------------the download_data_step

        tile_list_comma_delimited_string = ""
        for hv in tile_hv_names_to_match:
            tile_list_comma_delimited_string = tile_list_comma_delimited_string + "" + str(hv) + ','
        tile_list_comma_delimited_string = tile_list_comma_delimited_string[:-1]

        some_command = 'srun /home/rhussain/miniconda3/envs/uhi_env/bin/python /home/rhussain/urban-heat-islands/download_data_step.py --workpath ' + base_dir + ' --hv_tilelist ' + tile_list_comma_delimited_string + ' --start_year_inclusive  '+ str \
            (a_start_year_inclusive) +' --end_year_inclusive ' + str(
            a_end_year_inclusive) + ' --username ' + username + ' --password ' + password
        

        if dependency_string is None:
            # print(os.system("ls"))
            # https://cmdlinetips.com/2014/03/how-to-run-a-shell-command-from-python-and-get-the-output/
            out = subprocess.Popen(
                ['sbatch', '--job-name=urban_heat_islands_' + tile_list_comma_delimited_string + 'm2m_download_data',
                '--output=urban_heat_islands_' + tile_list_comma_delimited_string + 'm2m_download_data' + '.output',
                '--account=eros',
                '--partition=workq',
                '--nodes=1',
                '--ntasks=1',
                '--cpus-per-task=70',
                '--time=2-00:00:00',  # hpc limit is 2 days if u really need it
                '--mail-type=ALL',
                '--mail-user=rhussain@contractor.usgs.gov,sarab@contractor.usgs.gov',
                '--wrap=' + some_command + '',
                ],
                stdout=subprocess.PIPE,
                stderr=subprocess.STDOUT)
        else:
            # print(os.system("ls"))
            # https://cmdlinetips.com/2014/03/how-to-run-a-shell-command-from-python-and-get-the-output/
            out = subprocess.Popen(
                ['sbatch', '--job-name=urban_heat_islands_' + tile_list_comma_delimited_string + 'm2m_download_data',
                '--output=urban_heat_islands_' + tile_list_comma_delimited_string + 'm2m_download_data' + '.output',
                dependency_string,
                '--account=eros',
                '--partition=workq',
                '--nodes=1',
                '--ntasks=1',
                '--cpus-per-task=70',
                '--time=2-00:00:00',  # hpc limit is 2 days if u really need it
                '--mail-type=ALL',
                '--mail-user=rhussain@contractor.usgs.gov,sarab@contractor.usgs.gov',
                '--wrap=' + some_command + '',
                ],
                stdout=subprocess.PIPE,
                stderr=subprocess.STDOUT)

        time.sleep(1)
        stdout, stderr = out.communicate()
        print(subprocess.list2cmdline(out.args))
        print(stdout)

        # https://stackoverflow.com/questions/26825729/extract-number-from-string-in-python/26825781
        # basically when u submit a slurm job,
        # it returns a string that has one number in it, which is the slurm job id
        # so we just use a regex to get the number that is in the string
        all_numbers = re.findall("\d+", str(stdout))
        print(all_numbers)
        job_id = all_numbers[0]

        dependency_string = '--dependency=afterok:' + job_id






