

import os
import re
import subprocess
import datetime as dt

import time
import shutil

all_iata_codes = ["FSD","MSO","ORD","MKE","PHX","RDU","FAR","LIT","PIT","SDF","CYS","BOI","MSP","OMA","ABQ","LAS","DTW","BOS","OKC","MEM","BNA","ELP","DEN","IND","SFO","ATL","CMH","DFW","SAT","PHL","DSM","JAX","IAH","LAX","LGA","BHX","MSY","MIA","BWI","SLC","PHX","CVG","CLT","SMF","SEA","MCI","PDX","COS","SAN","AUS","DCA"]



#takes 00:06:15

#ran on 9/21
#runs for all cities
#---------------------------------------uhi_metrobuffer_generation.py
some_command = 'srun /home/rhussain/miniconda3/envs/uhi_env/bin/python /home/rhussain/urban-heat-islands-phase2/phase2_0_uhi_metrobuffer_generation.py'
# print(os.system("ls"))
# https://cmdlinetips.com/2014/03/how-to-run-a-shell-command-from-python-and-get-the-output/
out = subprocess.Popen(
['sbatch', '--job-name=phase2_0_uhi_metrobuffer_generation',
'--output=logs/phase2_0_uhi_metrobuffer_generation.output',
'--account=eros',
'--partition=workq',
'--nodes=1',
'--ntasks=1',
'--cpus-per-task=40',
'--time=2-00:00:00',  # hpc limit is 2 days if u really need it
'--mail-type=ALL',
'--mail-user=rhussain@contractor.usgs.gov',
'--wrap=' + some_command + '',
],
stdout=subprocess.PIPE,
stderr=subprocess.STDOUT)
stdout, stderr = out.communicate()
print(subprocess.list2cmdline(out.args))
print(stdout)
# https://stackoverflow.com/questions/26825729/extract-number-from-string-in-python/26825781
# basically when u submit a slurm job,
# it returns a string that has one number in it, which is the slurm job id
# so we just use a regex to get the number that is in the string
all_numbers = re.findall("\d+", str(stdout))
print(all_numbers)
job_id = all_numbers[0]
#dependency_string = '--dependency=afterok:' + job_id