

import os
import re
import subprocess
import datetime as dt

import time
import shutil

all_iata_codes = ["FSD","MSO","ORD","MKE","PHX","RDU","FAR","LIT","PIT","SDF","CYS","BOI","MSP","OMA","ABQ","LAS","DTW","BOS","OKC","MEM","BNA","ELP","DEN","IND","SFO","ATL","CMH","DFW","SAT","PHL","DSM","JAX","IAH","LAX","LGA","BHX","MSY","MIA","BWI","SLC","PHX","CVG","CLT","SMF","SEA","MCI","PDX","COS","SAN","AUS","DCA"]



# #takes 00:06:15

# #ran on 9/21
# #runs for all cities
# #---------------------------------------uhi_metrobuffer_generation.py
# some_command = 'srun /home/rhussain/miniconda3/envs/uhi_env/bin/python /home/rhussain/urban-heat-islands-phase2/phase2_0_uhi_metrobuffer_generation.py'
# # print(os.system("ls"))
# # https://cmdlinetips.com/2014/03/how-to-run-a-shell-command-from-python-and-get-the-output/
# out = subprocess.Popen(
# ['sbatch', '--job-name=phase2_0_uhi_metrobuffer_generation',
# '--output=logs/phase2_0_uhi_metrobuffer_generation.output',
# '--account=eros',
# '--partition=workq',
# '--nodes=1',
# '--ntasks=1',
# '--cpus-per-task=40',
# '--time=2-00:00:00',  # hpc limit is 2 days if u really need it
# '--mail-type=ALL',
# '--mail-user=rhussain@contractor.usgs.gov',
# '--wrap=' + some_command + '',
# ],
# stdout=subprocess.PIPE,
# stderr=subprocess.STDOUT)
# stdout, stderr = out.communicate()
# print(subprocess.list2cmdline(out.args))
# print(stdout)
# # https://stackoverflow.com/questions/26825729/extract-number-from-string-in-python/26825781
# # basically when u submit a slurm job,
# # it returns a string that has one number in it, which is the slurm job id
# # so we just use a regex to get the number that is in the string
# all_numbers = re.findall("\d+", str(stdout))
# print(all_numbers)
# job_id = all_numbers[0]
# dependency_string = '--dependency=afterok:' + job_id



#----------------------------------------------------------------------------------------------|


#this one takes 03:04:45 per site
#so here you can do the loop
#then add the job dependency

# base_output_directory_332 = "/caldera/projects/usgs/eros/urban_heat_islands/Phase2/section_332/output"
# if os.path.exists(base_output_directory_332):
#    shutil.rmtree(base_output_directory_332)
#    time.sleep(10)
# if not os.path.exists(base_output_directory_332):
#     os.mkdir(base_output_directory_332)
# #use this one not the one above
# for i in range(52):
# #for i in range(4):
#     #step
#     # for i in range(52): 332X
#     #this step runs on all iata codes, you dont need to pass one in for each
#     some_command = 'srun /home/rhussain/miniconda3/envs/uhi_env/bin/python /home/rhussain/urban-heat-islands-phase2/phase2_2_landcover_raster_generation_add_section_332X.py --site_tuples_index '+str(i)
#     # print(os.system("ls"))
#     # https://cmdlinetips.com/2014/03/how-to-run-a-shell-command-from-python-and-get-the-output/
#     out = subprocess.Popen(
#     ['sbatch', '--job-name=urban_heat_islands_landcover_raster_generation_add_section_332X_'+str(i),
#     '--output=logs/phase2_2_landcover_raster_generation_add_section_332X_'+str(i)+'.output',
#     '--account=eros',
#     '--partition=workq',
#     '--nodes=1',
#     '--ntasks=1',
#     '--cpus-per-task=40',
#     '--time=2-00:00:00',  # hpc limit is 2 days if u really need it
#     '--mail-type=ALL',
#     '--mail-user=rhussain@contractor.usgs.gov',
#     '--wrap=' + some_command + '',
#     ],
#     stdout=subprocess.PIPE,
#     stderr=subprocess.STDOUT)
#     stdout, stderr = out.communicate()
#     print(subprocess.list2cmdline(out.args))
#     print(stdout)
#     # https://stackoverflow.com/questions/26825729/extract-number-from-string-in-python/26825781
#     # basically when u submit a slurm job,
#     # it returns a string that has one number in it, which is the slurm job id
#     # so we just use a regex to get the number that is in the string
#     all_numbers = re.findall("\d+", str(stdout))
#     print(all_numbers)
#     job_id = all_numbers[0]
#     dependency_string = '--dependency=afterok:' + job_id





#the reason we need it here is because
#slurm jobs might run on different days
#this ensures that the date a slurm job looks for will be the same
#instead of one running on monday, and the second running on tuesday looking for a tuesday date
processing_date = dt.datetime.today().strftime('%Y%m%d')



#------------------------------------------------------------------------------phase2_1_uhi_urbanbuffer_clip
#any script that uses clipped_output_directory needs this one to finish first
#Run time 00:01:46

#ran on 9/21
chosen_iata_phase1_codes = all_iata_codes

#for iata_code in ["ATL", "IAH", "PHX","MSP"]:
#for iata_code in ["MSP","IAH"]:


#MSP should be ready
#for iata_code in ["ATL","MSP","OKC"]:
#for iata_code in ["BHX", "MSY", "PIT"]:
#PHL failed
#for iata_code in ["PHL","OKC","ATL"]:
#for iata_code in ["MSY","PHL"]:
#for iata_code in ["SAT","IND","OMA","ORD","BWI"]:





#for iata_code in ["MSO","FSD"]:#already transferred





#"DCA","BWI","ORD","OMA","IND","SAT","BHX","MSY","PIT","MSP","ATL","IAH","PHX","OKC","DFW","JAX", "DTW","CMH"


#-------------------------

# remaining 
# {'LAS', 'SEA', 'MKE', 'FAR', 'DSM', 'DEN', 'LIT', 'BOI', 'BNA', 'PDX', 'MIA', 'SMF', 'COS', 'ELP', 'MEM', 'SAN', 'BOS', 'SLC', 'RDU', 'CLT', 'CVG', 'ABQ', 'LAX', 'LGA', 'AUS', 'MCI', 'SFO', 'CYS', 'PHL'}

#in transferred
#for iata_code in ["CLT","SFO","BOI","LAS", "SEA", "MKE", "FAR", "DSM"]:

#needs transfer
#remaining {'DEN', 'LIT', 'BNA', 'PDX', 'MIA', 'SMF', 'COS', 'ELP', 'MEM', 'SAN', 'BOS', 'SLC', 'RDU', 'CVG', 'ABQ', 'LAX', 'LGA', 'AUS', 'MCI', , 'CYS', 'PHL'}
#for iata_code in ["DEN", "LIT", "BNA", "PDX", "MIA", "SMF", "COS", "ELP", "MEM", "SAN", "BOS", "SLC", "RDU", 
#"CVG", "ABQ", "LAX", "LGA", "AUS", "MCI", "CYS", "PHL"]:

#ok need to do
#AUS BNA BOS COS CYS DEN ELP LAX LIT LUK MCI MEM MIA PDX PHL RDU SAN SLC SMF

#,"BNA","BOS","COS","CYS","DEN","ELP","LAX","LIT","LUK","MCI","MEM","MIA","PDX","PHL","RDU","SAN","SLC","SMF"

#for iata_code in ["AUS"]:
#for iata_code in ["BNA","BOS","COS","CYS","DEN","ELP","LAX","LIT","LUK","MCI","MEM","MIA","PDX","PHL","RDU","SAN","SLC","SMF"]:

#my listsplitting into 3 parts
#for iata_code in ["BNA","BOS","COS","CYS","DEN","ELP"]:
#for iata_code in ["LAX","LIT","LUK","MCI","MEM","MIA"]:
#for iata_code in ["PDX","PHL","RDU","SAN","SLC","SMF"]:

#hua list
#succeeded BOS,DEN
#for iata_code in ["BNA","COS","CYS","ELP"]:#still processing as of 8/25
#need to transfer LAX,BNA,COS,CYS,ELP then delete and restart  the below

#transfer these
#"MCI","PDX","PHL","SAN","SLC"
#skip LUK cuz its CVG

#for iata_code in ["SMF","RDU",]:
for iata_code in ["SLC"]:

    #REMAINING
    #for iata_code in #"LIT","LUK","MCI",
    #for iata_code in ["PDX","PHL","RDU","SAN","SLC","SMF"]:

    phase_1_directory = "/caldera/projects/usgs/eros/urban_heat_islands/Phase1/"
    clipped_output_directory = '/caldera/projects/usgs/eros/urban_heat_islands/Phase1/' + iata_code + '/output_folder/' + 'LST_ANNUAL_CLIPPED'
    raster_list_base_path = '/caldera/projects/usgs/eros/urban_heat_islands/Phase1/' + iata_code + '/output_folder/ANNUAL'
    fn_zones_path = '/caldera/projects/usgs/eros/urban_heat_islands/Phase2/uhi_metrobuffer_generation/City_Boundaries_Dissolved/'+'ard_'+iata_code.lower()+'_city_dissolved.shp'
    #'/caldera/projects/usgs/eros/urban_heat_islands/Phase2/uhi_metrobuffer_generation/City_Boundaries_Dissolved/'+'ard_'+iata.lower()+'_city_dissolved.shp'
    some_command = 'srun /home/rhussain/miniconda3/envs/uhi_env/bin/python /home/rhussain/urban-heat-islands-phase2/phase2_1_uhi_urbanbuffer_clip.py --iata ' + str(iata_code) + ' --workdir ' +  str('/caldera/projects/usgs/eros/urban_heat_islands/Phase2/uhi_urbanbuffer_clip') + " --fn_zones " + fn_zones_path + " --clipped_output_directory " + clipped_output_directory + " --raster_list_base_path " + raster_list_base_path 
    # print(os.system("ls"))
    # https://cmdlinetips.com/2014/03/how-to-run-a-shell-command-from-python-and-get-the-output/
    out = subprocess.Popen(
    ['sbatch', '--job-name=phase2_1_uhi_urbanbuffer_clip_'+iata_code,
    '--output=logs/phase2_1_uhi_urbanbuffer_clip_'+iata_code+'.output',
    '--account=eros',
    '--partition=workq',
    '--nodes=1',
    '--ntasks=1',
    '--cpus-per-task=40',
    '--time=2-00:00:00',  # hpc limit is 2 days if u really need it
    '--mail-type=ALL',
    '--mail-user=rhussain@contractor.usgs.gov',
    '--wrap=' + some_command + '',
    ],
    stdout=subprocess.PIPE,
    stderr=subprocess.STDOUT)
    stdout, stderr = out.communicate()
    print(subprocess.list2cmdline(out.args))
    print(stdout)
    # https://stackoverflow.com/questions/26825729/extract-number-from-string-in-python/26825781
    # basically when u submit a slurm job,
    # it returns a string that has one number in it, which is the slurm job id
    # so we just use a regex to get the number that is in the string
    all_numbers = re.findall("\d+", str(stdout))
    print(all_numbers)
    job_id = all_numbers[0]
    dependency_string = '--dependency=afterok:' + job_id
    

    #-------------phase2_uhi_stats_buffered_stack
    #this step 2_3 does not need to wait for 2_1 
    # Run time 00:21:08

    phase_1_directory = "/caldera/projects/usgs/eros/urban_heat_islands/Phase1/"
    some_command = 'srun /home/rhussain/miniconda3/envs/uhi_env/bin/python /home/rhussain/urban-heat-islands-phase2/phase2_3_uhi_stats_buffered_stack.py --phase_1_directory ' + str(phase_1_directory) + ' --iata_location_identifier ' +  str(iata_code)
    # print(os.system("ls"))
    # https://cmdlinetips.com/2014/03/how-to-run-a-shell-command-from-python-and-get-the-output/
    out = subprocess.Popen(
    ['sbatch', '--job-name=phase2_3_uhi_stats_buffered_stack_'+iata_code,
    '--output=logs/phase2_3_uhi_stats_buffered_stack_'+iata_code+'.output',
    '--account=eros',
    '--partition=workq',
    '--nodes=1',
    '--ntasks=1',
    '--cpus-per-task=40',
    '--time=2-00:00:00',  # hpc limit is 2 days if u really need it
    '--mail-type=ALL',
    '--mail-user=rhussain@contractor.usgs.gov',
    dependency_string,
    '--wrap=' + some_command + '',
    ],
    stdout=subprocess.PIPE,
    stderr=subprocess.STDOUT)
    stdout, stderr = out.communicate()
    print(subprocess.list2cmdline(out.args))
    print(stdout)
    # https://stackoverflow.com/questions/26825729/extract-number-from-string-in-python/26825781
    # basically when u submit a slurm job,
    # it returns a string that has one number in it, which is the slurm job id
    # so we just use a regex to get the number that is in the string
    all_numbers = re.findall("\d+", str(stdout))
    print(all_numbers)
    job_id = all_numbers[0]
    dependency_string = '--dependency=afterok:' + job_id




# # #----------------------------------------------------------/caldera/projects/usgs/eros/urban_heat_islands/Phase2/section_345

    #this one needs 2_2 to be done before running
    #Run time 00:19:13

    metrobuffer_shapefile_root = "/caldera/projects/usgs/eros/urban_heat_islands/Phase2/uhi_metrobuffer_generation"
    full_path_to_dissolved_city_boundaries_shapefile = os.path.join(metrobuffer_shapefile_root,"City_Boundaries_Buffer","ard_"+iata_code+"_city_dissolved.shp")

    output_322_path = "/caldera/projects/usgs/eros/urban_heat_islands/Phase2/section_332/output/"+iata_code
    filenames = os.listdir(output_322_path)
    for filename in filenames:
        if "UHI_CU_"+iata_code+"_2020" in filename:
            raster_step_332_2020_path = os.path.join(output_322_path,filename)
        if "UHI_CU_"+iata_code+"_1985" in filename:
            raster_step_332_1985_path = os.path.join(output_322_path,filename)

    final_output_directory = "/caldera/projects/usgs/eros/urban_heat_islands/Phase2/section_345"+"/"+iata_code

    #output_urban_raster_name = "UHI_CU_"+iata_code+"_"+20211116+"_C01_PUC.tif"
    #output_non_urban_raster_name = "UHI_CU_"+iata_code+"_"+20211221+"_C01_PNC.tif"
    #output_new_urban_class_raster_name = "UHI_CU_"+iata_code+"_"+20211221+"_C01_NUC.tif"

    output_urban_raster_name = "UHI_CU_"+iata_code+ "_" + processing_date + "_C01_PUC.tif"
    output_non_urban_raster_name = "UHI_CU_"+iata_code+ "_" + processing_date + "_C01_PNC.tif"
    output_new_urban_class_raster_name = "UHI_CU_"+iata_code+ "_" + processing_date + "_C01_NUC.tif"

    some_command = 'srun /home/rhussain/miniconda3/envs/uhi_env/bin/python /home/rhussain/urban-heat-islands-phase2/phase2_5_landcover_raster_generation_section_345A.py --full_path_to_dissolved_city_boundaries_shapefile ' + str(full_path_to_dissolved_city_boundaries_shapefile) + ' --raster_step_332_1985_path ' +  str(raster_step_332_1985_path) + ' --raster_step_332_2020_path ' + str(raster_step_332_2020_path) + ' --final_output_directory '+ str(final_output_directory) + ' --output_urban_raster_name ' + str(output_urban_raster_name) + ' --output_non_urban_raster_name ' + str(output_non_urban_raster_name) + ' --output_new_urban_class_raster_name ' + str(output_new_urban_class_raster_name)
    print(some_command)
    # print(os.system("ls"))
    # https://cmdlinetips.com/2014/03/how-to-run-a-shell-command-from-python-and-get-the-output/
    out = subprocess.Popen(
    ['sbatch', '--job-name=phase2_landcover_raster_generation_section_345_'+iata_code,
    '--output=logs/phase2_landcover_raster_generation_section_345_'+iata_code+'.output',
    '--account=eros',
    '--partition=workq',
    '--nodes=1',
    '--ntasks=1',
    '--cpus-per-task=40',
    '--time=2-00:00:00',  # hpc limit is 2 days if u really need it
    '--mail-type=ALL',
    '--mail-user=rhussain@contractor.usgs.gov',
    dependency_string,
    '--wrap=' + some_command + '',
    ],
    stdout=subprocess.PIPE,
    stderr=subprocess.STDOUT)
    stdout, stderr = out.communicate()
    print(subprocess.list2cmdline(out.args))
    print(stdout)
    # https://stackoverflow.com/questions/26825729/extract-number-from-string-in-python/26825781
    # basically when u submit a slurm job,
    # it returns a string that has one number in it, which is the slurm job id
    # so we just use a regex to get the number that is in the string
    all_numbers = re.findall("\d+", str(stdout))
    print(all_numbers)
    job_id = all_numbers[0]
    dependency_string = '--dependency=afterok:' + job_id

#     #----------------------------------------------------------/caldera/projects/usgs/eros/urban_heat_islands/Phase2/section_346

    #this one needs 2_2 to finish before running
    #Run time 00:16:06

    metrobuffer_shapefile_root = "/caldera/projects/usgs/eros/urban_heat_islands/Phase2/uhi_metrobuffer_generation"
    full_path_to_dissolved_city_boundaries_shapefile = os.path.join(metrobuffer_shapefile_root,"City_Boundaries_Buffer","ard_"+iata_code+"_city_dissolved.shp")

    
    output_322_path = "/caldera/projects/usgs/eros/urban_heat_islands/Phase2/section_332/output/"+iata_code
    filenames = os.listdir(output_322_path)
    for filename in filenames:
        if "UHI_CU_"+iata_code+"_2020" in filename:
            raster_step_332_2020_path = os.path.join(output_322_path,filename)
        if "UHI_CU_"+iata_code+"_1985" in filename:
            raster_step_332_1985_path = os.path.join(output_322_path,filename)

            
    final_output_directory = "/caldera/projects/usgs/eros/urban_heat_islands/Phase2/section_346/"+iata_code

    # output_urban_raster_name = "UHI_CU_"+iata_code+"_20211116_C01_PUG.tif"
    # output_non_urban_raster_name = "UHI_CU_"+iata_code+"_20211221_C01_PNG.tif"
    # output_nug_raster_name = "UHI_CU_"+iata_code+"_20211221_C01_NUG.tif"

    output_urban_raster_name = "UHI_CU_"+iata_code+"_"+processing_date+"_C01_PUG.tif"
    output_non_urban_raster_name = "UHI_CU_"+iata_code+"_"+processing_date+"_C01_PNG.tif"
    output_nug_raster_name = "UHI_CU_"+iata_code+"_"+processing_date+"_C01_NUG.tif"


    some_command = 'srun /home/rhussain/miniconda3/envs/uhi_env/bin/python /home/rhussain/urban-heat-islands-phase2/phase2_6_landcover_raster_generation_section_346A.py --full_path_to_dissolved_city_boundaries_shapefile ' + str(full_path_to_dissolved_city_boundaries_shapefile) + ' --raster_step_332_1985_path ' +  str(raster_step_332_1985_path) + ' --raster_step_332_2020_path ' + str(raster_step_332_2020_path) + ' --final_output_directory '+ str(final_output_directory) + ' --output_urban_raster_name ' + str(output_urban_raster_name) + ' --output_non_urban_raster_name ' + str(output_non_urban_raster_name) + ' --output_nug_raster_name '+str(output_nug_raster_name)
    print(some_command)
    # print(os.system("ls"))
    # https://cmdlinetips.com/2014/03/how-to-run-a-shell-command-from-python-and-get-the-output/
    out = subprocess.Popen(
    ['sbatch', '--job-name=phase2_landcover_raster_generation_section_346A_'+iata_code,
    '--output=logs/phase2_landcover_raster_generation_section_346A'+iata_code+'.output',
    '--account=eros',
    '--partition=workq',
    '--nodes=1',
    '--ntasks=1',
    '--cpus-per-task=40',
    '--time=2-00:00:00',  # hpc limit is 2 days if u really need it
    '--mail-type=ALL',
    '--mail-user=rhussain@contractor.usgs.gov',
    dependency_string,
    '--wrap=' + some_command + '',
    ],
    stdout=subprocess.PIPE,
    stderr=subprocess.STDOUT)
    stdout, stderr = out.communicate()
    print(subprocess.list2cmdline(out.args))
    print(stdout)
    # https://stackoverflow.com/questions/26825729/extract-number-from-string-in-python/26825781
    # basically when u submit a slurm job,
    # it returns a string that has one number in it, which is the slurm job id
    # so we just use a regex to get the number that is in the string
    all_numbers = re.findall("\d+", str(stdout))
    print(all_numbers)
    job_id = all_numbers[0]
    dependency_string = '--dependency=afterok:' + job_id


    # #----------------------------------------------------------phase2_7_uhi_stats_citycen_total


    #takes 06:58:55 MSO
    #took 12hr for FSD though
    #/caldera/projects/usgs/eros/urban_heat_islands/Phase2/section_332/output/
    #phase_1_directory = "/caldera/projects/usgs/eros/urban_heat_islands/Phase1/"

    #iata_code = "FSD"
    workdir = "/caldera/projects/usgs/eros/urban_heat_islands/Phase1/" + iata_code + "/output_folder"
    metrobuffer_shapefile_root = "/caldera/projects/usgs/eros/urban_heat_islands/Phase2/uhi_metrobuffer_generation"
    uhi_lc_root = "/caldera/projects/usgs/eros/urban_heat_islands/Phase2/section_332/output/" + iata_code
    input_type = "ANNUAL"



    some_command = 'srun /home/rhussain/miniconda3/envs/uhi_env/bin/python /home/rhussain/urban-heat-islands-phase2/phase2_7_uhi_stats_citycen_total.py --workdir ' + str(workdir) + ' --iata_location_identifier ' +  str(iata_code) + ' --metrobuffer_shapefile_root ' + str(metrobuffer_shapefile_root) + ' --uhi_lc_root '+ str(uhi_lc_root) + ' --input_type ' + str(input_type)
    print(some_command)
    # print(os.system("ls"))
    # https://cmdlinetips.com/2014/03/how-to-run-a-shell-command-from-python-and-get-the-output/
    out = subprocess.Popen(
    ['sbatch', '--job-name=urban_heat_islands_phase2_7_uhi_stats_citycen_total'+iata_code,
    '--output=logs/phase2_7_uhi_stats_citycen_total_'+iata_code+'.output',
    '--account=eros',
    '--partition=workq',
    '--nodes=1',
    '--ntasks=1',
    '--cpus-per-task=40',
    '--time=2-00:00:00',  # hpc limit is 2 days if u really need it
    '--mail-type=ALL',
    '--mail-user=rhussain@contractor.usgs.gov',
    dependency_string,
    '--wrap=' + some_command + '',
    ],
    stdout=subprocess.PIPE,
    stderr=subprocess.STDOUT)
    stdout, stderr = out.communicate()
    print(subprocess.list2cmdline(out.args))
    print(stdout)
    # https://stackoverflow.com/questions/26825729/extract-number-from-string-in-python/26825781
    # basically when u submit a slurm job,
    # it returns a string that has one number in it, which is the slurm job id
    # so we just use a regex to get the number that is in the string
    all_numbers = re.findall("\d+", str(stdout))
    print(all_numbers)
    job_id = all_numbers[0]
    dependency_string = '--dependency=afterok:' + job_id

    # #----------------------------------------------------------phase2_uhi_stats_classbased_2_7


    #takes 06:58:55 MSO
    #took 12hr for FSD though
    #/caldera/projects/usgs/eros/urban_heat_islands/Phase2/section_332/output/
    #phase_1_directory = "/caldera/projects/usgs/eros/urban_heat_islands/Phase1/"

    #iata_code = "FSD"
    workdir = "/caldera/projects/usgs/eros/urban_heat_islands/Phase1/" + iata_code + "/output_folder"
    metrobuffer_shapefile_root = "/caldera/projects/usgs/eros/urban_heat_islands/Phase2/uhi_metrobuffer_generation"
    uhi_lc_root = "/caldera/projects/usgs/eros/urban_heat_islands/Phase2/section_332/output/" + iata_code
    input_type = "ANNUAL"



    some_command = 'srun /home/rhussain/miniconda3/envs/uhi_env/bin/python /home/rhussain/urban-heat-islands-phase2/phase2_7_uhi_stats_classbased.py --workdir ' + str(workdir) + ' --iata_location_identifier ' +  str(iata_code) + ' --metrobuffer_shapefile_root ' + str(metrobuffer_shapefile_root) + ' --uhi_lc_root '+ str(uhi_lc_root) + ' --input_type ' + str(input_type)
    print(some_command)
    # print(os.system("ls"))
    # https://cmdlinetips.com/2014/03/how-to-run-a-shell-command-from-python-and-get-the-output/
    out = subprocess.Popen(
    ['sbatch', '--job-name=2_7_urban_heat_islands_uhi_stats_classbased_'+iata_code,
    '--output=logs/phase2_7_uhi_stats_classbased_'+iata_code+'.output',
    '--account=eros',
    '--partition=workq',
    '--nodes=1',
    '--ntasks=1',
    '--cpus-per-task=40',
    '--time=2-00:00:00',  # hpc limit is 2 days if u really need it
    '--mail-type=ALL',
    '--mail-user=rhussain@contractor.usgs.gov',
    dependency_string,
    '--wrap=' + some_command + '',
    ],
    stdout=subprocess.PIPE,
    stderr=subprocess.STDOUT)
    stdout, stderr = out.communicate()
    print(subprocess.list2cmdline(out.args))
    print(stdout)
    # https://stackoverflow.com/questions/26825729/extract-number-from-string-in-python/26825781
    # basically when u submit a slurm job,
    # it returns a string that has one number in it, which is the slurm job id
    # so we just use a regex to get the number that is in the string
    all_numbers = re.findall("\d+", str(stdout))
    print(all_numbers)
    job_id = all_numbers[0]
    dependency_string = '--dependency=afterok:' + job_id


    # #----------------------------------------------------------/caldera/projects/usgs/eros/urban_heat_islands/Phase2/section_354F
    # #01:23:30 MSO

    output_345_path = "/caldera/projects/usgs/eros/urban_heat_islands/Phase2/section_345/"+iata_code
    output_346_path = "/caldera/projects/usgs/eros/urban_heat_islands/Phase2/section_346/"+iata_code
    stack_path = "/caldera/projects/usgs/eros/urban_heat_islands/Phase1/" + iata_code + "/output_folder/STACK"
    final_output_directory = "/caldera/projects/usgs/eros/urban_heat_islands/Phase2/section_354/"+iata_code
    phase1_total_folder_path = "/caldera/projects/usgs/eros/urban_heat_islands/Phase1/" + iata_code + "/output_folder/TOTAL"

    some_command = 'srun /home/rhussain/miniconda3/envs/uhi_env/bin/python /home/rhussain/urban-heat-islands-phase2/phase2_landcover_raster_generation_section_354F.py --output_345_path ' + str(output_345_path) + ' --output_346_path ' +  str(output_346_path) + ' --stack_path ' + str(stack_path) + ' --final_output_directory '+ str(final_output_directory) +' --phase1_total_folder_path ' + str(phase1_total_folder_path) + ' --iata_location_identifier '+ str(iata_code)
    print(some_command)
    # print(os.system("ls"))
    # https://cmdlinetips.com/2014/03/how-to-run-a-shell-command-from-python-and-get-the-output/
    out = subprocess.Popen(
    ['sbatch', '--job-name=phase2_landcover_raster_generation_section_354F_'+iata_code,
    '--output=logs/phase2_landcover_raster_generation_section_354F_'+iata_code+'.output',
    '--account=eros',
    '--partition=workq',
    '--nodes=1',
    '--ntasks=1',
    '--cpus-per-task=40',
    '--time=2-00:00:00',  # hpc limit is 2 days if u really need it
    '--mail-type=ALL',
    '--mail-user=rhussain@contractor.usgs.gov',
    dependency_string,
    '--wrap=' + some_command + '',
    ],
    stdout=subprocess.PIPE,
    stderr=subprocess.STDOUT)
    stdout, stderr = out.communicate()
    print(subprocess.list2cmdline(out.args))
    print(stdout)
    # https://stackoverflow.com/questions/26825729/extract-number-from-string-in-python/26825781
    # basically when u submit a slurm job,
    # it returns a string that has one number in it, which is the slurm job id
    # so we just use a regex to get the number that is in the string
    all_numbers = re.findall("\d+", str(stdout))
    print(all_numbers)
    job_id = all_numbers[0]
    dependency_string = '--dependency=afterok:' + job_id

    #----------------------------------------------------------phase2_8_uhi_intensity
    #Run time 00:08:29

    workdir = "/caldera/projects/usgs/eros/urban_heat_islands/Phase1/" + iata_code + "/output_folder"
    uhi_lc_root = "/caldera/projects/usgs/eros/urban_heat_islands/Phase2/section_332/output" + os.sep + iata_code + os.sep
    
    some_command = 'srun /home/rhussain/miniconda3/envs/uhi_env/bin/python /home/rhussain/urban-heat-islands-phase2/phase2_8_uhi_intensity.py --workdir ' + str(workdir) + ' --uhi_lc_root ' + str(uhi_lc_root) + ' --iata_location_identifier ' + str(iata_code)
    
    print(some_command)
    # print(os.system("ls"))
    # https://cmdlinetips.com/2014/03/how-to-run-a-shell-command-from-python-and-get-the-output/
    out = subprocess.Popen(
    ['sbatch', '--job-name=phase2_8_uhi_intensity_'+iata_code,
    '--output=logs/phase2_8_uhi_intensity_'+iata_code+'.output',
    '--account=eros',
    '--partition=workq',
    '--nodes=1',
    '--ntasks=1',
    '--cpus-per-task=40',
    '--time=2-00:00:00',  # hpc limit is 2 days if u really need it
    '--mail-type=ALL',
    dependency_string,
    '--mail-user=rhussain@contractor.usgs.gov',
    '--wrap=' + some_command + '',
    ],
    stdout=subprocess.PIPE,
    stderr=subprocess.STDOUT)
    stdout, stderr = out.communicate()
    print(subprocess.list2cmdline(out.args))
    print(stdout)
    # https://stackoverflow.com/questions/26825729/extract-number-from-string-in-python/26825781
    # basically when u submit a slurm job,
    # it returns a string that has one number in it, which is the slurm job id
    # so we just use a regex to get the number that is in the string
    all_numbers = re.findall("\d+", str(stdout))
    print(all_numbers)
    job_id = all_numbers[0]
    dependency_string = '--dependency=afterok:' + job_id




# # #----------------------------------------------------------feed 2_8 output into 2_7 script to generate

    workdir = "/caldera/projects/usgs/eros/urban_heat_islands/Phase1/" + iata_code + "/output_folder"
    metrobuffer_shapefile_root = "/caldera/projects/usgs/eros/urban_heat_islands/Phase2/uhi_metrobuffer_generation"
    uhi_lc_root = "/caldera/projects/usgs/eros/urban_heat_islands/Phase2/section_332/output/" + iata_code
    input_type = "ANNUAL"

    some_command = 'srun /home/rhussain/miniconda3/envs/uhi_env/bin/python /home/rhussain/urban-heat-islands-phase2/phase2_7b_uhi_stats_classbased.py --workdir ' + str(workdir) + ' --iata_location_identifier ' +  str(iata_code) + ' --metrobuffer_shapefile_root ' + str(metrobuffer_shapefile_root) + ' --uhi_lc_root '+ str(uhi_lc_root) + ' --input_type ' + str(input_type)
    print(some_command)
    # print(os.system("ls"))
    # https://cmdlinetips.com/2014/03/how-to-run-a-shell-command-from-python-and-get-the-output/
    out = subprocess.Popen(
    ['sbatch', '--job-name=urban_heat_islands_uhi_stats_classbased7b'+iata_code,
    '--output=logs/2_7b_urban_heat_islands_landcover_uhi_stats_classbased_7b'+iata_code+'.output',
    '--account=eros',
    '--partition=workq',
    '--nodes=1',
    '--ntasks=1',
    '--cpus-per-task=40',
    '--time=2-00:00:00',  # hpc limit is 2 days if u really need it
    dependency_string,
    '--mail-type=ALL',
    '--mail-user=rhussain@contractor.usgs.gov',
    '--wrap=' + some_command + '',
    ],
    stdout=subprocess.PIPE,
    stderr=subprocess.STDOUT)
    stdout, stderr = out.communicate()
    print(subprocess.list2cmdline(out.args))
    print(stdout)
    # https://stackoverflow.com/questions/26825729/extract-number-from-string-in-python/26825781
    # basically when u submit a slurm job,
    # it returns a string that has one number in it, which is the slurm job id
    # so we just use a regex to get the number that is in the string
    all_numbers = re.findall("\d+", str(stdout))
    print(all_numbers)
    job_id = all_numbers[0]
    dependency_string = '--dependency=afterok:' + job_id



#----------------------------------------------------------phase2_9_uhi_hotspot
    #Run time 00:14:09

    workdir = "/caldera/projects/usgs/eros/urban_heat_islands/Phase1/" + iata_code + "/output_folder"
    uhi_lc_root = "/caldera/projects/usgs/eros/urban_heat_islands/Phase2/section_332/output" + os.sep + iata_code + os.sep

    some_command = 'srun /home/rhussain/miniconda3/envs/uhi_env/bin/python /home/rhussain/urban-heat-islands-phase2/phase2_9_uhi_hotspot.py --workdir ' + str(workdir) + ' --uhi_lc_root ' + str(uhi_lc_root) + ' --iata_location_identifier ' + str(iata_code)
    
    print(some_command)
    # print(os.system("ls"))
    # https://cmdlinetips.com/2014/03/how-to-run-a-shell-command-from-python-and-get-the-output/
    out = subprocess.Popen(
    ['sbatch', '--job-name=phase2_9_uhi_hotspot_'+iata_code,
    '--output=logs/phase2_9_uhi_hotspot_'+iata_code+'.output',
    '--account=eros',
    '--partition=workq',
    '--nodes=1',
    '--ntasks=1',
    '--cpus-per-task=40',
    '--time=2-00:00:00',  # hpc limit is 2 days if u really need it
    '--mail-type=ALL',
    '--mail-user=rhussain@contractor.usgs.gov',
    dependency_string,
    '--wrap=' + some_command + '',
    ],
    stdout=subprocess.PIPE,
    stderr=subprocess.STDOUT)
    stdout, stderr = out.communicate()
    print(subprocess.list2cmdline(out.args))
    print(stdout)
    # https://stackoverflow.com/questions/26825729/extract-number-from-string-in-python/26825781
    # basically when u submit a slurm job,
    # it returns a string that has one number in it, which is the slurm job id
    # so we just use a regex to get the number that is in the string
    all_numbers = re.findall("\d+", str(stdout))
    print(all_numbers)
    job_id = all_numbers[0]
    dependency_string = '--dependency=afterok:' + job_id



# #     #----------------------------------------------------------phase2_10_uhi_hotspot_probability.py
# #     #Run time 00:03:11
    
    workdir = "/caldera/projects/usgs/eros/urban_heat_islands/Phase1/"
    some_command = 'srun /home/rhussain/miniconda3/envs/uhi_env/bin/python /home/rhussain/urban-heat-islands-phase2/phase2_10_uhi_hotspot_probability.py --phase_1_directory ' + str(workdir) + ' --iata_location_identifier ' + str(iata_code)
    
    print(some_command)
    # print(os.system("ls"))
    # https://cmdlinetips.com/2014/03/how-to-run-a-shell-command-from-python-and-get-the-output/
    out = subprocess.Popen(
    ['sbatch', '--job-name=phase2_10_uhi_hotspot_probability_'+iata_code,
    '--output=logs/phase2_10_uhi_hotspot_probability_'+iata_code+'.output',
    '--account=eros',
    '--partition=workq',
    '--nodes=1',
    '--ntasks=1',
    '--cpus-per-task=40',
    '--time=2-00:00:00',  # hpc limit is 2 days if u really need it
    '--mail-type=ALL',
    '--mail-user=rhussain@contractor.usgs.gov',
    dependency_string,
    '--wrap=' + some_command + '',
    ],
    stdout=subprocess.PIPE,
    stderr=subprocess.STDOUT)
    stdout, stderr = out.communicate()
    print(subprocess.list2cmdline(out.args))
    print(stdout)
    # https://stackoverflow.com/questions/26825729/extract-number-from-string-in-python/26825781
    # basically when u submit a slurm job,
    # it returns a string that has one number in it, which is the slurm job id
    # so we just use a regex to get the number that is in the string
    all_numbers = re.findall("\d+", str(stdout))
    print(all_numbers)
    job_id = all_numbers[0]
    dependency_string = '--dependency=afterok:' + job_id





#     #----------------------------------------------------------phase2_12_uhi_stats_citycenbased.py
#     #Run time 00:01:06,

    metrobuffer_shapefile_root = "/caldera/projects/usgs/eros/urban_heat_islands/Phase2/uhi_metrobuffer_generation"
    workdir = "/caldera/projects/usgs/eros/urban_heat_islands/Phase1/" + iata_code + "/output_folder"

    some_command = "srun /home/rhussain/miniconda3/envs/uhi_env/bin/python /home/rhussain/urban-heat-islands-phase2/phase2_12_uhi_stats_citycenbased.py --workdir " + workdir + " --iata " + iata_code
    print(some_command)
    # print(os.system("ls"))
    # https://cmdlinetips.com/2014/03/how-to-run-a-shell-command-from-python-and-get-the-output/
    out = subprocess.Popen(
    ['sbatch', '--job-name=phase2_12_uhi_stats_citycenbased_'+iata_code,
    '--output=logs/phase2_12_uhi_stats_citycenbased_'+iata_code+'.output',
    '--account=eros',
    '--partition=workq',
    '--nodes=1',
    '--ntasks=1',
    '--cpus-per-task=40',
    '--time=2-00:00:00',  # hpc limit is 2 days if u really need it
    '--mail-type=ALL',
    '--mail-user=rhussain@contractor.usgs.gov',
    dependency_string,
    '--wrap=' + some_command + '',
    ],
    stdout=subprocess.PIPE,
    stderr=subprocess.STDOUT)
    stdout, stderr = out.communicate()
    print(subprocess.list2cmdline(out.args))
    print(stdout)
    # https://stackoverflow.com/questions/26825729/extract-number-from-string-in-python/26825781
    # basically when u submit a slurm job,
    # it returns a string that has one number in it, which is the slurm job id
    # so we just use a regex to get the number that is in the string
    all_numbers = re.findall("\d+", str(stdout))
    print(all_numbers)
    job_id = all_numbers[0]
    dependency_string = '--dependency=afterok:' + job_id

#----------------------------------------------------------phase2_13_uhi_stats_citycenbased_intensity
    #Run time 00:01:06

    metrobuffer_shapefile_root = "/caldera/projects/usgs/eros/urban_heat_islands/Phase2/uhi_metrobuffer_generation"
    workdir = "/caldera/projects/usgs/eros/urban_heat_islands/Phase1/" + iata_code + "/output_folder"

    some_command = "srun /home/rhussain/miniconda3/envs/uhi_env/bin/python /home/rhussain/urban-heat-islands-phase2/phase2_13_uhi_stats_citycenbased_intensity.py --workdir " + workdir + " --iata " + iata_code
    print(some_command)
    # print(os.system("ls"))
    # https://cmdlinetips.com/2014/03/how-to-run-a-shell-command-from-python-and-get-the-output/
    out = subprocess.Popen(
    ['sbatch', '--job-name=phase2_13_uhi_stats_citycenbased_intensity_'+iata_code,
    '--output=logs/phase2_13_uhi_stats_citycenbased_intensity_'+iata_code+'.output',
    '--account=eros',
    '--partition=workq',
    '--nodes=1',
    '--ntasks=1',
    '--cpus-per-task=40',
    '--time=2-00:00:00',  # hpc limit is 2 days if u really need it
    '--mail-type=ALL',
    '--mail-user=rhussain@contractor.usgs.gov',
    dependency_string,
    '--wrap=' + some_command + '',
    ],
    stdout=subprocess.PIPE,
    stderr=subprocess.STDOUT)
    stdout, stderr = out.communicate()
    print(subprocess.list2cmdline(out.args))
    print(stdout)
    # https://stackoverflow.com/questions/26825729/extract-number-from-string-in-python/26825781
    # basically when u submit a slurm job,
    # it returns a string that has one number in it, which is the slurm job id
    # so we just use a regex to get the number that is in the string
    all_numbers = re.findall("\d+", str(stdout))
    print(all_numbers)
    job_id = all_numbers[0]
    dependency_string = '--dependency=afterok:' + job_id


# # #----------------------------------------------------------phase2_14_trends_standalone_intensity
# #     #Run time 00:06:26

    input_folder = "/caldera/projects/usgs/eros/urban_heat_islands/Phase1/" + iata_code + "/output_folder/INTENSITY_ANNUAL"
    output_folder = "/caldera/projects/usgs/eros/urban_heat_islands/Phase1/" + iata_code + "/output_folder/INTENSITY_STACK"

    some_command = "srun /home/rhussain/miniconda3/envs/uhi_env/bin/python /home/rhussain/urban-heat-islands-phase2/phase2_14_trends_standalone_intensity.py --input_folder " + input_folder + " --output_folder " + output_folder
    print(some_command)
    # print(os.system("ls"))
    # https://cmdlinetips.com/2014/03/how-to-run-a-shell-command-from-python-and-get-the-output/
    out = subprocess.Popen(
    ['sbatch', '--job-name=phase2_14_trends_standalone_intensity_'+iata_code,
    '--output=logs/phase2_14_trends_standalone_intensity_'+iata_code+'.output',
    '--account=eros',
    '--partition=workq',
    '--nodes=1',
    '--ntasks=1',
    '--cpus-per-task=40',
    '--time=2-00:00:00',  # hpc limit is 2 days if u really need it
    '--mail-type=ALL',
    '--mail-user=rhussain@contractor.usgs.gov',
    dependency_string,
    '--wrap=' + some_command + '',
    ],
    stdout=subprocess.PIPE,
    stderr=subprocess.STDOUT)
    stdout, stderr = out.communicate()
    print(subprocess.list2cmdline(out.args))
    print(stdout)
    # https://stackoverflow.com/questions/26825729/extract-number-from-string-in-python/26825781
    # basically when u submit a slurm job,
    # it returns a string that has one number in it, which is the slurm job id
    # so we just use a regex to get the number that is in the string
    all_numbers = re.findall("\d+", str(stdout))
    print(all_numbers)
    job_id = all_numbers[0]
    dependency_string = '--dependency=afterok:' + job_id



#     # #----------------------------------------------------------phase2_16_uhi_intensity_stack
#     # #Run time 00:02:43
#     # iata_code = iata_code

    some_command = 'srun /home/rhussain/miniconda3/envs/uhi_env/bin/python /home/rhussain/urban-heat-islands-phase2/phase2_16_uhi_intensity_stack.py --iata_code ' +  str(iata_code)
    print(some_command)
    # print(os.system("ls"))
    # https://cmdlinetips.com/2014/03/how-to-run-a-shell-command-from-python-and-get-the-output/
    out = subprocess.Popen(
    ['sbatch', '--job-name=phase2_16_uhi_intensity_stack_'+iata_code,
    '--output=logs/phase2_16_uhi_intensity_stack_'+iata_code+'.output',
    '--account=eros',
    '--partition=workq',
    '--nodes=1',
    '--ntasks=1',
    '--cpus-per-task=40',
    '--time=2-00:00:00',  # hpc limit is 2 days if u really need it
    '--mail-type=ALL',
    '--mail-user=rhussain@contractor.usgs.gov',
    dependency_string,
    '--wrap=' + some_command + '',
    ],
    stdout=subprocess.PIPE,
    stderr=subprocess.STDOUT)
    stdout, stderr = out.communicate()
    print(subprocess.list2cmdline(out.args))
    print(stdout)
    # https://stackoverflow.com/questions/26825729/extract-number-from-string-in-python/26825781
    # basically when u submit a slurm job,
    # it returns a string that has one number in it, which is the slurm job id
    # so we just use a regex to get the number that is in the string
    all_numbers = re.findall("\d+", str(stdout))
    print(all_numbers)
    job_id = all_numbers[0]
    dependency_string = '--dependency=afterok:' + job_id


#yes this needs to run after 2_16
#     #----------------------------------------------------------phase2_15_uhi_stats_citycenbased_total_intensity
#     # #Run time 00:00:14

    workdir = "/caldera/projects/usgs/eros/urban_heat_islands/Phase1/" + iata_code + "/output_folder"
    iata_code = iata_code
    metrobuffer_shapefile_root = "/caldera/projects/usgs/eros/urban_heat_islands/Phase2/uhi_metrobuffer_generation"
    uhi_lc_root = "/caldera/projects/usgs/eros/urban_heat_islands/Phase2/section_332/output/" + iata_code
    intensity_stack_folder_path = "/caldera/projects/usgs/eros/urban_heat_islands/Phase1/"+iata_code+"/output_folder/INTENSITY_STACK"

    

    #iata_code = "FSD"
    #some_command = 'srun /home/rhussain/miniconda3/envs/uhi_env/bin/python /home/rhussain/urban-heat-islands-phase2/empty_python_script.py'
    some_command = 'srun /home/rhussain/miniconda3/envs/uhi_env/bin/python /home/rhussain/urban-heat-islands-phase2/phase2_15_uhi_stats_citycenbased_total_intensity.py --workdir ' + str(workdir) + ' --iata_code ' +  str(iata_code) + ' --metrobuffer_shapefile_root ' + str(metrobuffer_shapefile_root) + ' --uhi_lc_root '+ str(uhi_lc_root) + ' --intensity_stack_folder_path ' + str(intensity_stack_folder_path)
    print(some_command)
    # print(os.system("ls"))
    # https://cmdlinetips.com/2014/03/how-to-run-a-shell-command-from-python-and-get-the-output/
    out = subprocess.Popen(
    ['sbatch', '--job-name=phase2_15_uhi_stats_citycenbased_total_intensity'+iata_code,
    '--output=logs/phase2_15_uhi_stats_citycenbased_total_intensity'+iata_code+'.output',
    '--account=eros',
    '--partition=workq',
    '--nodes=1',
    '--ntasks=1',
    '--cpus-per-task=40',
    '--time=2-00:00:00',  # hpc limit is 2 days if u really need it
    '--mail-type=ALL',
    '--mail-user=rhussain@contractor.usgs.gov',
    dependency_string,
    '--wrap=' + some_command + '',
    ],
    stdout=subprocess.PIPE,
    stderr=subprocess.STDOUT)
    stdout, stderr = out.communicate()
    print(subprocess.list2cmdline(out.args))
    print(stdout)
    # https://stackoverflow.com/questions/26825729/extract-number-from-string-in-python/26825781
    # basically when u submit a slurm job,
    # it returns a string that has one number in it, which is the slurm job id
    # so we just use a regex to get the number that is in the string
    all_numbers = re.findall("\d+", str(stdout))
    print(all_numbers)
    job_id = all_numbers[0]
    dependency_string = '--dependency=afterok:' + job_id



#     # #----------------------------------------------------------phase2_17_uhi_stats_citycenbased
#     # #Run time 00:01:30


    
    workdir = "/caldera/projects/usgs/eros/urban_heat_islands/Phase1/" + iata_code + "/output_folder"
    iata_code = iata_code
    metrobuffer_shapefile_root = "/caldera/projects/usgs/eros/urban_heat_islands/Phase2/uhi_metrobuffer_generation"
    uhi_lc_root = "/caldera/projects/usgs/eros/urban_heat_islands/Phase2/section_332/output/" + iata_code

    some_command = 'srun /home/rhussain/miniconda3/envs/uhi_env/bin/python /home/rhussain/urban-heat-islands-phase2/phase2_17_uhi_stats_citycenbased.py --workdir ' + str(workdir) + ' --iata_code ' +  str(iata_code) + ' --metrobuffer_shapefile_root ' + str(metrobuffer_shapefile_root) + ' --uhi_lc_root '+ str(uhi_lc_root)
    print(some_command)

    # print(os.system("ls"))
    # https://cmdlinetips.com/2014/03/how-to-run-a-shell-command-from-python-and-get-the-output/
    
    out = subprocess.Popen(
    ['sbatch', '--job-name=phase2_17_uhi_stats_citycenbased_'+iata_code,
    '--output=logs/phase2_17_uhi_stats_citycenbased_'+iata_code+'.output',
    '--account=eros',
    '--partition=workq',
    '--nodes=1',
    '--ntasks=1',
    '--cpus-per-task=40',
    '--time=2-00:00:00',  # hpc limit is 2 days if u really need it
    '--mail-type=ALL',
    '--mail-user=rhussain@contractor.usgs.gov',
    dependency_string,
    '--wrap=' + some_command + '',
    ],
    stdout=subprocess.PIPE,
    stderr=subprocess.STDOUT)
    stdout, stderr = out.communicate()
    print(subprocess.list2cmdline(out.args))
    print(stdout)
    # https://stackoverflow.com/questions/26825729/extract-number-from-string-in-python/26825781
    # basically when u submit a slurm job,
    # it returns a string that has one number in it, which is the slurm job id
    # so we just use a regex to get the number that is in the string
    all_numbers = re.findall("\d+", str(stdout))
    print(all_numbers)
    job_id = all_numbers[0]
    dependency_string = '--dependency=afterok:' + job_id

    # #------------------------------------------------------------------------------------phase2_18_uhi_stats_citycenbased_total
    # #Run time 00:00:26

    workdir = "/caldera/projects/usgs/eros/urban_heat_islands/Phase1/" + iata_code + "/output_folder"
    iata_code = iata_code
    metrobuffer_shapefile_root = "/caldera/projects/usgs/eros/urban_heat_islands/Phase2/uhi_metrobuffer_generation"
    uhi_lc_root = "/caldera/projects/usgs/eros/urban_heat_islands/Phase2/section_332/output/" + iata_code

    some_command = 'srun /home/rhussain/miniconda3/envs/uhi_env/bin/python /home/rhussain/urban-heat-islands-phase2/phase2_18_uhi_stats_citycenbased_total.py --workdir ' + str(workdir) + ' --iata_code ' +  str(iata_code) + ' --metrobuffer_shapefile_root ' + str(metrobuffer_shapefile_root) + ' --uhi_lc_root '+ str(uhi_lc_root)
    print(some_command)

    # print(os.system("ls"))
    # https://cmdlinetips.com/2014/03/how-to-run-a-shell-command-from-python-and-get-the-output/
    
    out = subprocess.Popen(
    ['sbatch', '--job-name=phase2_18_uhi_stats_citycenbased_total_'+iata_code,
    '--output=logs/phase2_18_uhi_stats_citycenbased_total_'+iata_code+'.output',
    '--account=eros',
    '--partition=workq',
    '--nodes=1',
    '--ntasks=1',
    '--cpus-per-task=40',
    '--time=2-00:00:00',  # hpc limit is 2 days if u really need it
    '--mail-type=ALL',
    dependency_string,
    '--mail-user=rhussain@contractor.usgs.gov',
    '--wrap=' + some_command + '',
    ],
    stdout=subprocess.PIPE,
    stderr=subprocess.STDOUT)
    stdout, stderr = out.communicate()
    print(subprocess.list2cmdline(out.args))
    print(stdout)
    # https://stackoverflow.com/questions/26825729/extract-number-from-string-in-python/26825781
    # basically when u submit a slurm job,
    # it returns a string that has one number in it, which is the slurm job id
    # so we just use a regex to get the number that is in the string
    all_numbers = re.findall("\d+", str(stdout))
    print(all_numbers)
    job_id = all_numbers[0]
    dependency_string = '--dependency=afterok:' + job_id

    #---------------------------------------------------------------------------------------





#     #------------------------------------------------------------------------------------phase2_19_uhi_stats_classbased_hotspot
#     #Run time 00:05:10

    
    workdir = "/caldera/projects/usgs/eros/urban_heat_islands/Phase1/" + iata_code + "/output_folder"
    iata_code = iata_code
    metrobuffer_shapefile_root = "/caldera/projects/usgs/eros/urban_heat_islands/Phase2/uhi_metrobuffer_generation"
    uhi_lc_root = "/caldera/projects/usgs/eros/urban_heat_islands/Phase2/section_332/output/" + iata_code

    some_command = 'srun /home/rhussain/miniconda3/envs/uhi_env/bin/python /home/rhussain/urban-heat-islands-phase2/phase2_19_uhi_stats_classbased_hotspot.py --workdir ' + str(workdir) + ' --iata_code ' +  str(iata_code) + ' --metrobuffer_shapefile_root ' + str(metrobuffer_shapefile_root) + ' --uhi_lc_root '+ str(uhi_lc_root)
    print(some_command)

    # print(os.system("ls"))
    # https://cmdlinetips.com/2014/03/how-to-run-a-shell-command-from-python-and-get-the-output/
    
    out = subprocess.Popen(
    ['sbatch', '--job-name=phase2_19_uhi_stats_classbased_hotspot_'+iata_code,
    '--output=logs/phase2_19_uhi_stats_classbased_hotspot_'+iata_code+'.output',
    '--account=eros',
    '--partition=workq',
    '--nodes=1',
    '--ntasks=1',
    '--cpus-per-task=40',
    '--time=2-00:00:00',  # hpc limit is 2 days if u really need it
    '--mail-type=ALL',
    '--mail-user=rhussain@contractor.usgs.gov',
    dependency_string,
    '--wrap=' + some_command + '',
    ],
    stdout=subprocess.PIPE,
    stderr=subprocess.STDOUT)
    stdout, stderr = out.communicate()
    print(subprocess.list2cmdline(out.args))
    print(stdout)
    # https://stackoverflow.com/questions/26825729/extract-number-from-string-in-python/26825781
    # basically when u submit a slurm job,
    # it returns a string that has one number in it, which is the slurm job id
    # so we just use a regex to get the number that is in the string
    all_numbers = re.findall("\d+", str(stdout))
    print(all_numbers)
    job_id = all_numbers[0]
    dependency_string = '--dependency=afterok:' + job_id


# #---------------------------------------------------------------------------------------


# #------------------------------------------------------------------------------------phase2_20_uhi_stats_citycenbased_nugrowth

#     #needs 354 to complete first
#     # Run time 00:00:39
    
    workdir = "/caldera/projects/usgs/eros/urban_heat_islands/Phase1/" + iata_code + "/output_folder"
    iata_code = iata_code
    metrobuffer_shapefile_root = "/caldera/projects/usgs/eros/urban_heat_islands/Phase2/uhi_metrobuffer_generation"
    uhi_lc_root = "/caldera/projects/usgs/eros/urban_heat_islands/Phase2/section_332/output/" + iata_code
    section_354_directory = "/caldera/projects/usgs/eros/urban_heat_islands/Phase2/section_354/"+iata_code


    some_command = 'srun /home/rhussain/miniconda3/envs/uhi_env/bin/python /home/rhussain/urban-heat-islands-phase2/phase2_20_uhi_stats_citycenbased_nugrowth.py --workdir ' + str(workdir) + ' --iata_code ' +  str(iata_code) + ' --metrobuffer_shapefile_root ' + str(metrobuffer_shapefile_root) + ' --uhi_lc_root '+ str(uhi_lc_root) + ' --section_354_directory '+str(section_354_directory)
    print(some_command)

    # print(os.system("ls"))
    # https://cmdlinetips.com/2014/03/how-to-run-a-shell-command-from-python-and-get-the-output/
    
    out = subprocess.Popen(
    ['sbatch', '--job-name=phase2_20_uhi_stats_citycenbased_nugrowth'+iata_code,
    '--output=logs/phase2_20_uhi_stats_citycenbased_nugrowth'+iata_code+'.output',
    '--account=eros',
    '--partition=workq',
    '--nodes=1',
    '--ntasks=1',
    '--cpus-per-task=40',
    '--time=2-00:00:00',  # hpc limit is 2 days if u really need it
    '--mail-type=ALL',
    '--mail-user=rhussain@contractor.usgs.gov',
    dependency_string,
    '--wrap=' + some_command + '',
    ],
    stdout=subprocess.PIPE,
    stderr=subprocess.STDOUT)
    stdout, stderr = out.communicate()
    print(subprocess.list2cmdline(out.args))
    print(stdout)
    # https://stackoverflow.com/questions/26825729/extract-number-from-string-in-python/26825781
    # basically when u submit a slurm job,
    # it returns a string that has one number in it, which is the slurm job id
    # so we just use a regex to get the number that is in the string
    all_numbers = re.findall("\d+", str(stdout))
    print(all_numbers)
    job_id = all_numbers[0]
    dependency_string = '--dependency=afterok:' + job_id



# #------------------------------------------------------------------------------------phase2_21_uhi_stats_citycenbased_persistent
#     #Run time 00:00:31
#     #needs 354 to complete first
    
    workdir = "/caldera/projects/usgs/eros/urban_heat_islands/Phase1/" + iata_code + "/output_folder"
    iata_code = iata_code
    metrobuffer_shapefile_root = "/caldera/projects/usgs/eros/urban_heat_islands/Phase2/uhi_metrobuffer_generation"
    uhi_lc_root = "/caldera/projects/usgs/eros/urban_heat_islands/Phase2/section_332/output/" + iata_code
    section_354_directory = "/caldera/projects/usgs/eros/urban_heat_islands/Phase2/section_354/"+iata_code

    some_command = 'srun /home/rhussain/miniconda3/envs/uhi_env/bin/python /home/rhussain/urban-heat-islands-phase2/phase2_21_uhi_stats_citycenbased_persistent.py --workdir ' + str(workdir) + ' --iata_code ' +  str(iata_code) + ' --metrobuffer_shapefile_root ' + str(metrobuffer_shapefile_root) + ' --uhi_lc_root '+ str(uhi_lc_root) + ' --section_354_directory '+str(section_354_directory)
    print(some_command)

    # print(os.system("ls"))
    # https://cmdlinetips.com/2014/03/how-to-run-a-shell-command-from-python-and-get-the-output/
    
    out = subprocess.Popen(
    ['sbatch', '--job-name=phase2_21_uhi_stats_citycenbased_persistent'+iata_code,
    '--output=logs/phase2_21_uhi_stats_citycenbased_persistent'+iata_code+'.output',
    '--account=eros',
    '--partition=workq',
    '--nodes=1',
    '--ntasks=1',
    '--cpus-per-task=40',
    '--time=2-00:00:00',  # hpc limit is 2 days if u really need it
    '--mail-type=ALL',
    '--mail-user=rhussain@contractor.usgs.gov',
    dependency_string,
    '--wrap=' + some_command + '',
    ],
    stdout=subprocess.PIPE,
    stderr=subprocess.STDOUT)
    stdout, stderr = out.communicate()
    print(subprocess.list2cmdline(out.args))
    print(stdout)
    # https://stackoverflow.com/questions/26825729/extract-number-from-string-in-python/26825781
    # basically when u submit a slurm job,
    # it returns a string that has one number in it, which is the slurm job id
    # so we just use a regex to get the number that is in the string
    all_numbers = re.findall("\d+", str(stdout))
    print(all_numbers)
    job_id = all_numbers[0]
    dependency_string = '--dependency=afterok:' + job_id


# ----------------------------------------------------------phase2_11_generate_city_center_masks.py
# Run time 00:00:16

#this script runs on all, u dont need to pass in iata one at a time
#has to be run separately though

# workdir = "/caldera/projects/usgs/eros/urban_heat_islands/Phase1/"

# some_command = 'srun /home/rhussain/miniconda3/envs/uhi_env/bin/python /home/rhussain/urban-heat-islands-phase2/phase2_11_generate_city_center_masks.py --phase_1_directory ' + str(workdir)

# print(some_command)
# # print(os.system("ls"))
# # https://cmdlinetips.com/2014/03/how-to-run-a-shell-command-from-python-and-get-the-output/
# out = subprocess.Popen(
# ['sbatch', '--job-name=phase2_11_generate_city_center_masks',
# '--output=phase2_11_generate_city_center_masks.output',
# '--account=eros',
# '--partition=workq',
# '--nodes=1',
# '--ntasks=1',
# '--cpus-per-task=40',
# '--time=2-00:00:00',  # hpc limit is 2 days if u really need it
# '--mail-type=ALL',
# '--mail-user=rhussain@contractor.usgs.gov',
# '--wrap=' + some_command + '',
# ],
# stdout=subprocess.PIPE,
# stderr=subprocess.STDOUT)
# stdout, stderr = out.communicate()
# print(subprocess.list2cmdline(out.args))
# print(stdout)
# # https://stackoverflow.com/questions/26825729/extract-number-from-string-in-python/26825781
# # basically when u submit a slurm job,
# # it returns a string that has one number in it, which is the slurm job id
# # so we just use a regex to get the number that is in the string
# all_numbers = re.findall("\d+", str(stdout))
# print(all_numbers)
# job_id = all_numbers[0]
# dependency_string = '--dependency=afterok:' + job_id


