import os
import re
import subprocess




"""
#---------------------------------------uhi_metrobuffer_generation.py
some_command = 'srun /home/rhussain/miniconda3/envs/uhi_env/bin/python /home/rhussain/urban-heat-islands-phase2/phase2_uhi_metrobuffer_generation.py'
# print(os.system("ls"))
# https://cmdlinetips.com/2014/03/how-to-run-a-shell-command-from-python-and-get-the-output/
out = subprocess.Popen(
['sbatch', '--job-name=urban_heat_islands_metrobuffer_generation',
'--output=urban_heat_islands_metrobuffer_generation.output',
'--account=eros',
'--partition=workq',
'--nodes=1',
'--ntasks=1',
'--cpus-per-task=40',
'--time=2-00:00:00',  # hpc limit is 2 days if u really need it
'--mail-type=ALL',
'--mail-user=rhussain@contractor.usgs.gov',
'--wrap=' + some_command + '',
],
stdout=subprocess.PIPE,
stderr=subprocess.STDOUT)
stdout, stderr = out.communicate()
print(subprocess.list2cmdline(out.args))
print(stdout)
# https://stackoverflow.com/questions/26825729/extract-number-from-string-in-python/26825781
# basically when u submit a slurm job,
# it returns a string that has one number in it, which is the slurm job id
# so we just use a regex to get the number that is in the string
all_numbers = re.findall("\d+", str(stdout))
print(all_numbers)
job_id = all_numbers[0]
dependency_string = '--dependency=afterok:' + job_id
"""




#------------------------------------------------------------------------------phase2_1_uhi_urbanbuffer_clip
'''
chosen_iata_phase1_codes = ["MSO","FSD"]

for iata_code in chosen_iata_phase1_codes:

    phase_1_directory = "/caldera/projects/usgs/eros/urban_heat_islands/Phase1/"
    #iata_code = "FSD"

    clipped_output_directory = '/caldera/projects/usgs/eros/urban_heat_islands/Phase1/' + iata_code + '/output_folder/' + 'LST_ANNUAL_CLIPPED'
    raster_list_base_path = '/caldera/projects/usgs/eros/urban_heat_islands/Phase1/' + iata_code + '/output_folder/ANNUAL'
    fn_zones_path = '/caldera/projects/usgs/eros/urban_heat_islands/Phase2/uhi_metrobuffer_generation/City_Boundaries_Dissolved/'+'ard_'+iata_code.lower()+'_city_dissolved.shp'
    #'/caldera/projects/usgs/eros/urban_heat_islands/Phase2/uhi_metrobuffer_generation/City_Boundaries_Dissolved/'+'ard_'+iata.lower()+'_city_dissolved.shp'

    some_command = 'srun /home/rhussain/miniconda3/envs/uhi_env/bin/python /home/rhussain/urban-heat-islands-phase2/phase2_1_uhi_urbanbuffer_clip.py --iata ' + str(iata_code) + ' --workdir ' +  str('/caldera/projects/usgs/eros/urban_heat_islands/Phase2/uhi_urbanbuffer_clip') + " --fn_zones " + fn_zones_path + " --clipped_output_directory " + clipped_output_directory + " --raster_list_base_path " + raster_list_base_path 
    # print(os.system("ls"))
    # https://cmdlinetips.com/2014/03/how-to-run-a-shell-command-from-python-and-get-the-output/
    out = subprocess.Popen(
    ['sbatch', '--job-name=phase2_1_uhi_urbanbuffer_clip',
    '--output=phase2_1_uhi_urbanbuffer_clip.output',
    '--account=eros',
    '--partition=workq',
    '--nodes=1',
    '--ntasks=1',
    '--cpus-per-task=40',
    '--time=2-00:00:00',  # hpc limit is 2 days if u really need it
    '--mail-type=ALL',
    '--mail-user=rhussain@contractor.usgs.gov',
    '--wrap=' + some_command + '',
    ],
    stdout=subprocess.PIPE,
    stderr=subprocess.STDOUT)
    stdout, stderr = out.communicate()
    print(subprocess.list2cmdline(out.args))
    print(stdout)
    # https://stackoverflow.com/questions/26825729/extract-number-from-string-in-python/26825781
    # basically when u submit a slurm job,
    # it returns a string that has one number in it, which is the slurm job id
    # so we just use a regex to get the number that is in the string
    all_numbers = re.findall("\d+", str(stdout))
    print(all_numbers)
    job_id = all_numbers[0]
    dependency_string = '--dependency=afterok:' + job_id
'''
#----------------------------------------------------------------------------------------------|

'''
#step 332V
#this step runs on all iata codes, you dont need to pass one in for each

some_command = 'srun /home/rhussain/miniconda3/envs/uhi_env/bin/python /home/rhussain/urban-heat-islands-phase2/phase2_2_landcover_raster_generation_add_section_332V_scratch.py'
# print(os.system("ls"))
# https://cmdlinetips.com/2014/03/how-to-run-a-shell-command-from-python-and-get-the-output/
out = subprocess.Popen(
['sbatch', '--job-name=urban_heat_islands_landcover_raster_generation_add_section_332V',
'--output=urban_heat_islands_landcover_raster_generation_add_section_332V.output',
'--account=eros',
'--partition=workq',
'--nodes=1',
'--ntasks=1',
'--cpus-per-task=40',
'--time=2-00:00:00',  # hpc limit is 2 days if u really need it
'--mail-type=ALL',
'--mail-user=rhussain@contractor.usgs.gov',
'--wrap=' + some_command + '',
],
stdout=subprocess.PIPE,
stderr=subprocess.STDOUT)
stdout, stderr = out.communicate()
print(subprocess.list2cmdline(out.args))
print(stdout)
# https://stackoverflow.com/questions/26825729/extract-number-from-string-in-python/26825781
# basically when u submit a slurm job,
# it returns a string that has one number in it, which is the slurm job id
# so we just use a regex to get the number that is in the string
all_numbers = re.findall("\d+", str(stdout))
print(all_numbers)
job_id = all_numbers[0]
dependency_string = '--dependency=afterok:' + job_id
'''

#----------------------------------------------------------------------------------------------|

#-------------phase2_uhi_stats_buffered_stack
'''
chosen_iata_phase1_codes = ["FSD","MSO"]

for iata_code in chosen_iata_phase1_codes:

    phase_1_directory = "/caldera/projects/usgs/eros/urban_heat_islands/Phase1/"
    #iata_code = "FSD"
    some_command = 'srun /home/rhussain/miniconda3/envs/uhi_env/bin/python /home/rhussain/urban-heat-islands-phase2/phase2_uhi_stats_buffered_stack.py --phase_1_directory ' + str(phase_1_directory) + ' --iata_location_identifier ' +  str(iata_code)
    # print(os.system("ls"))
    # https://cmdlinetips.com/2014/03/how-to-run-a-shell-command-from-python-and-get-the-output/
    out = subprocess.Popen(
    ['sbatch', '--job-name=urban_heat_islands_uhi_stats_buffered_stack',
    '--output=urban_heat_islands_landcover_uhi_stats_buffered_stack.output',
    '--account=eros',
    '--partition=workq',
    '--nodes=1',
    '--ntasks=1',
    '--cpus-per-task=40',
    '--time=2-00:00:00',  # hpc limit is 2 days if u really need it
    '--mail-type=ALL',
    '--mail-user=rhussain@contractor.usgs.gov',
    '--wrap=' + some_command + '',
    ],
    stdout=subprocess.PIPE,
    stderr=subprocess.STDOUT)
    stdout, stderr = out.communicate()
    print(subprocess.list2cmdline(out.args))
    print(stdout)
    # https://stackoverflow.com/questions/26825729/extract-number-from-string-in-python/26825781
    # basically when u submit a slurm job,
    # it returns a string that has one number in it, which is the slurm job id
    # so we just use a regex to get the number that is in the string
    all_numbers = re.findall("\d+", str(stdout))
    print(all_numbers)
    job_id = all_numbers[0]
    dependency_string = '--dependency=afterok:' + job_id
'''



'''
#----------------------------------------------------------/home/rhussain/urban-heat-islands-phase2/phase2_landcover_raster_generation_section_344.py

#/caldera/projects/usgs/eros/urban_heat_islands/Phase2/section_344

# dont have MSO fixed shapefile from fixed so use Sioux Falls from here until Chase provides a 
# new metrobuffer script
chosen_iata_phase1_codes = ["FSD"]

for iata_code in chosen_iata_phase1_codes:

    metrobuffer_shapefile_root = "/caldera/projects/usgs/eros/urban_heat_islands/Phase2/uhi_metrobuffer_generation"

    full_path_to_dissolved_city_boundaries_shapefile = os.path.join(metrobuffer_shapefile_root,"City_Boundaries_Buffer","ard_"+iata_code+"_city_dissolved.shp")

    output_322_path = "/caldera/projects/usgs/eros/urban_heat_islands/Phase2/section_332/output/"+iata_code
    filenames = os.listdir(output_322_path)
    for filename in filenames:
        if "UHI_CU_"+iata_code+"_2020" in filename:
            raster_step_332_2020_path = os.path.join(output_322_path,filename)
        if "UHI_CU_"+iata_code+"_1985" in filename:
            raster_step_332_1985_path = os.path.join(output_322_path,filename)

    final_output_directory = "/caldera/projects/usgs/eros/urban_heat_islands/Phase2/section_344"

    some_command = 'srun /home/rhussain/miniconda3/envs/uhi_env/bin/python /home/rhussain/urban-heat-islands-phase2/phase2_landcover_raster_generation_section_344.py --full_path_to_dissolved_city_boundaries_shapefile ' + str(full_path_to_dissolved_city_boundaries_shapefile) + ' --raster_step_332_1985_path ' +  str(raster_step_332_1985_path) + ' --raster_step_332_2020_path ' + str(raster_step_332_2020_path) + ' --final_output_directory '+ str(final_output_directory)
    print(some_command)
    # print(os.system("ls"))
    # https://cmdlinetips.com/2014/03/how-to-run-a-shell-command-from-python-and-get-the-output/
    out = subprocess.Popen(
    ['sbatch', '--job-name=phase2_landcover_raster_generation_section_344',
    '--output=phase2_landcover_raster_generation_section_344.output',
    '--account=eros',
    '--partition=workq',
    '--nodes=1',
    '--ntasks=1',
    '--cpus-per-task=40',
    '--time=2-00:00:00',  # hpc limit is 2 days if u really need it
    '--mail-type=ALL',
    '--mail-user=rhussain@contractor.usgs.gov',
    '--wrap=' + some_command + '',
    ],
    stdout=subprocess.PIPE,
    stderr=subprocess.STDOUT)
    stdout, stderr = out.communicate()
    print(subprocess.list2cmdline(out.args))
    print(stdout)
    # https://stackoverflow.com/questions/26825729/extract-number-from-string-in-python/26825781
    # basically when u submit a slurm job,
    # it returns a string that has one number in it, which is the slurm job id
    # so we just use a regex to get the number that is in the string
    all_numbers = re.findall("\d+", str(stdout))
    print(all_numbers)
    job_id = all_numbers[0]
    dependency_string = '--dependency=afterok:' + job_id


'''
#----------------------------------------------------------/caldera/projects/usgs/eros/urban_heat_islands/Phase2/section_345

'''
chosen_iata_phase1_codes = ["FSD","MSO"]

for iata_code in chosen_iata_phase1_codes:

    metrobuffer_shapefile_root = "/caldera/projects/usgs/eros/urban_heat_islands/Phase2/uhi_metrobuffer_generation"
    full_path_to_dissolved_city_boundaries_shapefile = os.path.join(metrobuffer_shapefile_root,"City_Boundaries_Buffer","ard_"+iata_code+"_city_dissolved.shp")

    output_322_path = "/caldera/projects/usgs/eros/urban_heat_islands/Phase2/section_332/output/"+iata_code
    filenames = os.listdir(output_322_path)
    for filename in filenames:
        if "UHI_CU_"+iata_code+"_2020" in filename:
            raster_step_332_2020_path = os.path.join(output_322_path,filename)
        if "UHI_CU_"+iata_code+"_1985" in filename:
            raster_step_332_1985_path = os.path.join(output_322_path,filename)

    final_output_directory = "/caldera/projects/usgs/eros/urban_heat_islands/Phase2/section_345"

    output_urban_raster_name = "UHI_CU_"+iata_code+"_20211116_C01_PUC.tif"
    output_non_urban_raster_name = "UHI_CU_"+iata_code+"_20211221_C01_PNC.tif"
    output_new_urban_class_raster_name = "UHI_CU_"+iata_code+"_20211221_C01_NUC.tif"

    some_command = 'srun /home/rhussain/miniconda3/envs/uhi_env/bin/python /home/rhussain/urban-heat-islands-phase2/phase2_5_landcover_raster_generation_section_345A.py --full_path_to_dissolved_city_boundaries_shapefile ' + str(full_path_to_dissolved_city_boundaries_shapefile) + ' --raster_step_332_1985_path ' +  str(raster_step_332_1985_path) + ' --raster_step_332_2020_path ' + str(raster_step_332_2020_path) + ' --final_output_directory '+ str(final_output_directory) + ' --output_urban_raster_name ' + str(output_urban_raster_name) + ' --output_non_urban_raster_name ' + str(output_non_urban_raster_name) + ' --output_new_urban_class_raster_name ' + str(output_new_urban_class_raster_name)
    print(some_command)
    # print(os.system("ls"))
    # https://cmdlinetips.com/2014/03/how-to-run-a-shell-command-from-python-and-get-the-output/
    out = subprocess.Popen(
    ['sbatch', '--job-name=phase2_landcover_raster_generation_section_345',
    '--output=phase2_landcover_raster_generation_section_345_'+iata_code+'.output',
    '--account=eros',
    '--partition=workq',
    '--nodes=1',
    '--ntasks=1',
    '--cpus-per-task=40',
    '--time=2-00:00:00',  # hpc limit is 2 days if u really need it
    '--mail-type=ALL',
    '--mail-user=rhussain@contractor.usgs.gov',
    '--wrap=' + some_command + '',
    ],
    stdout=subprocess.PIPE,
    stderr=subprocess.STDOUT)
    stdout, stderr = out.communicate()
    print(subprocess.list2cmdline(out.args))
    print(stdout)
    # https://stackoverflow.com/questions/26825729/extract-number-from-string-in-python/26825781
    # basically when u submit a slurm job,
    # it returns a string that has one number in it, which is the slurm job id
    # so we just use a regex to get the number that is in the string
    all_numbers = re.findall("\d+", str(stdout))
    print(all_numbers)
    job_id = all_numbers[0]
    dependency_string = '--dependency=afterok:' + job_id
'''

#----------------------------------------------------------/caldera/projects/usgs/eros/urban_heat_islands/Phase2/section_346


'''
# dont have MSO fixed shapefile from fixed so use Sioux Falls from here until Chase provides a 
# new metrobuffer script
chosen_iata_phase1_codes = ["FSD"]

for iata_code in chosen_iata_phase1_codes:

    metrobuffer_shapefile_root = "/caldera/projects/usgs/eros/urban_heat_islands/Phase2/uhi_metrobuffer_generation"
    full_path_to_dissolved_city_boundaries_shapefile = os.path.join(metrobuffer_shapefile_root,"City_Boundaries_Buffer","ard_"+iata_code+"_city_dissolved.shp")

    
    output_322_path = "/caldera/projects/usgs/eros/urban_heat_islands/Phase2/section_332/output/"+iata_code
    filenames = os.listdir(output_322_path)
    for filename in filenames:
        if "UHI_CU_"+iata_code+"_2020" in filename:
            raster_step_332_2020_path = os.path.join(output_322_path,filename)
        if "UHI_CU_"+iata_code+"_1985" in filename:
            raster_step_332_1985_path = os.path.join(output_322_path,filename)

            
    final_output_directory = "/caldera/projects/usgs/eros/urban_heat_islands/Phase2/section_346"

    output_urban_raster_name = "UHI_CU_FSD_20211116_C01_PUG.tif"
    output_non_urban_raster_name = "UHI_CU_FSD_20211221_C01_PNG.tif"


    some_command = 'srun /home/rhussain/miniconda3/envs/uhi_env/bin/python /home/rhussain/urban-heat-islands-phase2/phase2_landcover_raster_generation_section_346A.py --full_path_to_dissolved_city_boundaries_shapefile ' + str(full_path_to_dissolved_city_boundaries_shapefile) + ' --raster_step_332_1985_path ' +  str(raster_step_332_1985_path) + ' --raster_step_332_2020_path ' + str(raster_step_332_2020_path) + ' --final_output_directory '+ str(final_output_directory) + ' --output_urban_raster_name ' + str(output_urban_raster_name) + ' --output_non_urban_raster_name ' + str(output_non_urban_raster_name)
    print(some_command)
    # print(os.system("ls"))
    # https://cmdlinetips.com/2014/03/how-to-run-a-shell-command-from-python-and-get-the-output/
    out = subprocess.Popen(
    ['sbatch', '--job-name=phase2_landcover_raster_generation_section_346A',
    '--output=phase2_landcover_raster_generation_section_346A.output',
    '--account=eros',
    '--partition=workq',
    '--nodes=1',
    '--ntasks=1',
    '--cpus-per-task=40',
    '--time=2-00:00:00',  # hpc limit is 2 days if u really need it
    '--mail-type=ALL',
    '--mail-user=rhussain@contractor.usgs.gov',
    '--wrap=' + some_command + '',
    ],
    stdout=subprocess.PIPE,
    stderr=subprocess.STDOUT)
    stdout, stderr = out.communicate()
    print(subprocess.list2cmdline(out.args))
    print(stdout)
    # https://stackoverflow.com/questions/26825729/extract-number-from-string-in-python/26825781
    # basically when u submit a slurm job,
    # it returns a string that has one number in it, which is the slurm job id
    # so we just use a regex to get the number that is in the string
    all_numbers = re.findall("\d+", str(stdout))
    print(all_numbers)
    job_id = all_numbers[0]
    dependency_string = '--dependency=afterok:' + job_id


'''


#----------------------------------------------------------phase2_uhi_stats_classbased
'''

#/caldera/projects/usgs/eros/urban_heat_islands/Phase2/section_332/output/

# dont have MSO fixed shapefile from fixed so use Sioux Falls from here until Chase provides a 
# new metrobuffer script
chosen_iata_phase1_codes = ["FSD","MSO"]
#chosen_iata_phase1_codes = ["MSO"]

for iata_code in chosen_iata_phase1_codes:
    
    #phase_1_directory = "/caldera/projects/usgs/eros/urban_heat_islands/Phase1/"

    workdir = "/caldera/projects/usgs/eros/urban_heat_islands/Phase1/" + iata_code + "/output_folder"
    metrobuffer_shapefile_root = "/caldera/projects/usgs/eros/urban_heat_islands/Phase2/uhi_metrobuffer_generation"
    uhi_lc_root = "/caldera/projects/usgs/eros/urban_heat_islands/Phase2/section_332/output/" + iata_code
    input_type = "ANNUAL"

    #iata_code = "FSD"
    #some_command = 'srun /home/rhussain/miniconda3/envs/uhi_env/bin/python /home/rhussain/urban-heat-islands-phase2/empty_python_script.py'
    some_command = 'srun /home/rhussain/miniconda3/envs/uhi_env/bin/python /home/rhussain/urban-heat-islands-phase2/phase2_7_uhi_stats_classbased.py --workdir ' + str(workdir) + ' --iata_location_identifier ' +  str(iata_code) + ' --metrobuffer_shapefile_root ' + str(metrobuffer_shapefile_root) + ' --uhi_lc_root '+ str(uhi_lc_root) + ' --input_type ' + str(input_type)
    print(some_command)
    # print(os.system("ls"))
    # https://cmdlinetips.com/2014/03/how-to-run-a-shell-command-from-python-and-get-the-output/
    out = subprocess.Popen(
    ['sbatch', '--job-name=urban_heat_islands_uhi_stats_classbased',
    '--output=urban_heat_islands_landcover_uhi_stats_classbased_'+iata_code+'.output',
    '--account=eros',
    '--partition=workq',
    '--nodes=1',
    '--ntasks=1',
    '--cpus-per-task=40',
    '--time=2-00:00:00',  # hpc limit is 2 days if u really need it
    '--mail-type=ALL',
    '--mail-user=rhussain@contractor.usgs.gov',
    '--wrap=' + some_command + '',
    ],
    stdout=subprocess.PIPE,
    stderr=subprocess.STDOUT)
    stdout, stderr = out.communicate()
    print(subprocess.list2cmdline(out.args))
    print(stdout)
    # https://stackoverflow.com/questions/26825729/extract-number-from-string-in-python/26825781
    # basically when u submit a slurm job,
    # it returns a string that has one number in it, which is the slurm job id
    # so we just use a regex to get the number that is in the string
    all_numbers = re.findall("\d+", str(stdout))
    print(all_numbers)
    job_id = all_numbers[0]
    dependency_string = '--dependency=afterok:' + job_id
'''

#----------------------------------------------------------/caldera/projects/usgs/eros/urban_heat_islands/Phase2/section_354F

chosen_iata_phase1_codes = ["FSD","MSO"]

for iata_code in chosen_iata_phase1_codes:

    output_345_path = "/caldera/projects/usgs/eros/urban_heat_islands/Phase2/section_345"
    filenames = os.listdir(output_345_path)
    for filename in filenames:
        if "PUC" in filename and iata_code in filename:
            persistent_urban_class_raster_path_from_345 = os.path.join(output_345_path,filename)
        if "PNC" in filename and iata_code in filename:
            persistent_non_urban_class_raster_path_from_345 = os.path.join(output_345_path,filename)
        if "NUC" in filename and iata_code in filename:
            output_new_urban_class_raster_path_from_345 = os.path.join(output_345_path,filename)


    output_346_path = "/caldera/projects/usgs/eros/urban_heat_islands/Phase2/section_346"
    filenames = os.listdir(output_346_path)
    for filename in filenames:
        if "PUG" in filename and iata_code in filename:
            persistent_urban_coverage_raster_path_from_346 = os.path.join(output_346_path,filename)
        if "PNG" in filename and iata_code in filename:
            persistent_non_urban_coverage_raster_path_from_346 = os.path.join(output_346_path,filename)

    stack_path = "/caldera/projects/usgs/eros/urban_heat_islands/Phase1/" + iata_code + "/output_folder/STACK"

    filenames = os.listdir(stack_path)
    for filename in filenames:
        if "MAXLST_MEAN" in filename:
            max_lst_mean_raster_stack_path = os.path.join(stack_path,filename)
        if "MEANLST_MEAN" in filename:
            mean_lst_mean_raster_stack_path = os.path.join(stack_path,filename)
        if "MINLST_MEAN" in filename:
            min_lst_mean_raster_stack_path = os.path.join(stack_path,filename)

    final_output_directory = "/caldera/projects/usgs/eros/urban_heat_islands/Phase2/section_354"
    
    phase1_total_folder_path = "/caldera/projects/usgs/eros/urban_heat_islands/Phase1/" + iata_code + "/output_folder/TOTAL"

    some_command = 'srun /home/rhussain/miniconda3/envs/uhi_env/bin/python /home/rhussain/urban-heat-islands-phase2/phase2_landcover_raster_generation_section_354F.py --persistent_urban_class_raster_path_from_345 ' + str(persistent_urban_class_raster_path_from_345) + ' --persistent_non_urban_class_raster_path_from_345 ' +  str(persistent_non_urban_class_raster_path_from_345) + ' --persistent_urban_coverage_raster_path_from_346 ' + str(persistent_urban_coverage_raster_path_from_346) + ' --persistent_non_urban_coverage_raster_path_from_346 '+ str(persistent_non_urban_coverage_raster_path_from_346) +' --output_new_urban_class_raster_path_from_345 ' + str(output_new_urban_class_raster_path_from_345) + ' --max_lst_mean_raster_stack_path ' + str(max_lst_mean_raster_stack_path) + ' --mean_lst_mean_raster_stack_path ' + str(mean_lst_mean_raster_stack_path) + ' --min_lst_mean_raster_stack_path ' + str(min_lst_mean_raster_stack_path) + ' --final_output_directory ' + str(final_output_directory) + ' --iata_location_identifier ' + str(iata_code) + ' --phase1_total_folder_path ' + str(phase1_total_folder_path)
    print(some_command)
    # print(os.system("ls"))
    # https://cmdlinetips.com/2014/03/how-to-run-a-shell-command-from-python-and-get-the-output/
    out = subprocess.Popen(
    ['sbatch', '--job-name=phase2_landcover_raster_generation_section_354F',
    '--output=phase2_landcover_raster_generation_section_354F_'+iata_code+'.output',
    '--account=eros',
    '--partition=workq',
    '--nodes=1',
    '--ntasks=1',
    '--cpus-per-task=40',
    '--time=2-00:00:00',  # hpc limit is 2 days if u really need it
    '--mail-type=ALL',
    '--mail-user=rhussain@contractor.usgs.gov',
    '--wrap=' + some_command + '',
    ],
    stdout=subprocess.PIPE,
    stderr=subprocess.STDOUT)
    stdout, stderr = out.communicate()
    print(subprocess.list2cmdline(out.args))
    print(stdout)
    # https://stackoverflow.com/questions/26825729/extract-number-from-string-in-python/26825781
    # basically when u submit a slurm job,
    # it returns a string that has one number in it, which is the slurm job id
    # so we just use a regex to get the number that is in the string
    all_numbers = re.findall("\d+", str(stdout))
    print(all_numbers)
    job_id = all_numbers[0]
    dependency_string = '--dependency=afterok:' + job_id




#----------------------------------------------------------phase2_8_uhi_intensity
'''
chosen_iata_phase1_codes = ["FSD"]

for iata_code in chosen_iata_phase1_codes:

    workdir = "/caldera/projects/usgs/eros/urban_heat_islands/Phase1/" + iata_code + "/output_folder"
    uhi_lc_root = "/caldera/projects/usgs/eros/urban_heat_islands/Phase2/section_332/output" + os.sep + iata_code + os.sep
    
    some_command = 'srun /home/rhussain/miniconda3/envs/uhi_env/bin/python /home/rhussain/urban-heat-islands-phase2/phase2_8_uhi_intensity.py --workdir ' + str(workdir) + ' --uhi_lc_root ' + str(uhi_lc_root) + ' --iata_location_identifier ' + str(iata_code)
    #some_command = 'srun /home/rhussain/miniconda3/envs/uhi_env/bin/python /home/rhussain/urban-heat-islands-phase2/phase2_landcover_raster_generation_section_354F.py --persistent_urban_class_raster_path_from_345 ' + str(persistent_urban_class_raster_path_from_345) + ' --persistent_non_urban_class_raster_path_from_345 ' +  str(persistent_non_urban_class_raster_path_from_345) + ' --persistent_urban_coverage_raster_path_from_346 ' + str(persistent_urban_coverage_raster_path_from_346) + ' --persistent_non_urban_coverage_raster_path_from_346 '+ str(persistent_non_urban_coverage_raster_path_from_346) + ' --max_lst_mean_raster_stack_path ' + str(max_lst_mean_raster_stack_path) + ' --mean_lst_mean_raster_stack_path ' + str(mean_lst_mean_raster_stack_path) + ' --min_lst_mean_raster_stack_path ' + str(min_lst_mean_raster_stack_path) + ' --final_output_directory ' + str(final_output_directory)
    
    print(some_command)
    # print(os.system("ls"))
    # https://cmdlinetips.com/2014/03/how-to-run-a-shell-command-from-python-and-get-the-output/
    out = subprocess.Popen(
    ['sbatch', '--job-name=phase2_8_uhi_intensity',
    '--output=phase2_8_uhi_intensity.output',
    '--account=eros',
    '--partition=workq',
    '--nodes=1',
    '--ntasks=1',
    '--cpus-per-task=40',
    '--time=2-00:00:00',  # hpc limit is 2 days if u really need it
    '--mail-type=ALL',
    '--mail-user=rhussain@contractor.usgs.gov',
    '--wrap=' + some_command + '',
    ],
    stdout=subprocess.PIPE,
    stderr=subprocess.STDOUT)
    stdout, stderr = out.communicate()
    print(subprocess.list2cmdline(out.args))
    print(stdout)
    # https://stackoverflow.com/questions/26825729/extract-number-from-string-in-python/26825781
    # basically when u submit a slurm job,
    # it returns a string that has one number in it, which is the slurm job id
    # so we just use a regex to get the number that is in the string
    all_numbers = re.findall("\d+", str(stdout))
    print(all_numbers)
    job_id = all_numbers[0]
    dependency_string = '--dependency=afterok:' + job_id

'''

#----------------------------------------------------------phase2_9_uhi_hotspot



'''

chosen_iata_phase1_codes = ["FSD"]

for iata_code in chosen_iata_phase1_codes:

    workdir = "/caldera/projects/usgs/eros/urban_heat_islands/Phase1/" + iata_code + "/output_folder"
    uhi_lc_root = "/caldera/projects/usgs/eros/urban_heat_islands/Phase2/section_332/output" + os.sep + iata_code + os.sep
    
    some_command = 'srun /home/rhussain/miniconda3/envs/uhi_env/bin/python /home/rhussain/urban-heat-islands-phase2/phase2_9_uhi_hotspot.py --workdir ' + str(workdir) + ' --uhi_lc_root ' + str(uhi_lc_root) + ' --iata_location_identifier ' + str(iata_code)
    #some_command = 'srun /home/rhussain/miniconda3/envs/uhi_env/bin/python /home/rhussain/urban-heat-islands-phase2/phase2_landcover_raster_generation_section_354F.py --persistent_urban_class_raster_path_from_345 ' + str(persistent_urban_class_raster_path_from_345) + ' --persistent_non_urban_class_raster_path_from_345 ' +  str(persistent_non_urban_class_raster_path_from_345) + ' --persistent_urban_coverage_raster_path_from_346 ' + str(persistent_urban_coverage_raster_path_from_346) + ' --persistent_non_urban_coverage_raster_path_from_346 '+ str(persistent_non_urban_coverage_raster_path_from_346) + ' --max_lst_mean_raster_stack_path ' + str(max_lst_mean_raster_stack_path) + ' --mean_lst_mean_raster_stack_path ' + str(mean_lst_mean_raster_stack_path) + ' --min_lst_mean_raster_stack_path ' + str(min_lst_mean_raster_stack_path) + ' --final_output_directory ' + str(final_output_directory)
    
    print(some_command)
    # print(os.system("ls"))
    # https://cmdlinetips.com/2014/03/how-to-run-a-shell-command-from-python-and-get-the-output/
    out = subprocess.Popen(
    ['sbatch', '--job-name=phase2_9_uhi_hotspot',
    '--output=phase2_9_uhi_hotspot.output',
    '--account=eros',
    '--partition=workq',
    '--nodes=1',
    '--ntasks=1',
    '--cpus-per-task=40',
    '--time=2-00:00:00',  # hpc limit is 2 days if u really need it
    '--mail-type=ALL',
    '--mail-user=rhussain@contractor.usgs.gov',
    '--wrap=' + some_command + '',
    ],
    stdout=subprocess.PIPE,
    stderr=subprocess.STDOUT)
    stdout, stderr = out.communicate()
    print(subprocess.list2cmdline(out.args))
    print(stdout)
    # https://stackoverflow.com/questions/26825729/extract-number-from-string-in-python/26825781
    # basically when u submit a slurm job,
    # it returns a string that has one number in it, which is the slurm job id
    # so we just use a regex to get the number that is in the string
    all_numbers = re.findall("\d+", str(stdout))
    print(all_numbers)
    job_id = all_numbers[0]
    dependency_string = '--dependency=afterok:' + job_id


'''



#----------------------------------------------------------phase2_10_uhi_hotspot_probability.py
'''

chosen_iata_phase1_codes = ["FSD"]

for iata_code in chosen_iata_phase1_codes:

    workdir = "/caldera/projects/usgs/eros/urban_heat_islands/Phase1/"
    
    some_command = 'srun /home/rhussain/miniconda3/envs/uhi_env/bin/python /home/rhussain/urban-heat-islands-phase2/phase2_10_uhi_hotspot_probability.py --phase_1_directory ' + str(workdir) + ' --iata_location_identifier ' + str(iata_code)
    #some_command = 'srun /home/rhussain/miniconda3/envs/uhi_env/bin/python /home/rhussain/urban-heat-islands-phase2/phase2_landcover_raster_generation_section_354F.py --persistent_urban_class_raster_path_from_345 ' + str(persistent_urban_class_raster_path_from_345) + ' --persistent_non_urban_class_raster_path_from_345 ' +  str(persistent_non_urban_class_raster_path_from_345) + ' --persistent_urban_coverage_raster_path_from_346 ' + str(persistent_urban_coverage_raster_path_from_346) + ' --persistent_non_urban_coverage_raster_path_from_346 '+ str(persistent_non_urban_coverage_raster_path_from_346) + ' --max_lst_mean_raster_stack_path ' + str(max_lst_mean_raster_stack_path) + ' --mean_lst_mean_raster_stack_path ' + str(mean_lst_mean_raster_stack_path) + ' --min_lst_mean_raster_stack_path ' + str(min_lst_mean_raster_stack_path) + ' --final_output_directory ' + str(final_output_directory)
    
    print(some_command)
    # print(os.system("ls"))
    # https://cmdlinetips.com/2014/03/how-to-run-a-shell-command-from-python-and-get-the-output/
    out = subprocess.Popen(
    ['sbatch', '--job-name=phase2_10_uhi_hotspot_probability',
    '--output=phase2_10_uhi_hotspot_probability.output',
    '--account=eros',
    '--partition=workq',
    '--nodes=1',
    '--ntasks=1',
    '--cpus-per-task=40',
    '--time=2-00:00:00',  # hpc limit is 2 days if u really need it
    '--mail-type=ALL',
    '--mail-user=rhussain@contractor.usgs.gov',
    '--wrap=' + some_command + '',
    ],
    stdout=subprocess.PIPE,
    stderr=subprocess.STDOUT)
    stdout, stderr = out.communicate()
    print(subprocess.list2cmdline(out.args))
    print(stdout)
    # https://stackoverflow.com/questions/26825729/extract-number-from-string-in-python/26825781
    # basically when u submit a slurm job,
    # it returns a string that has one number in it, which is the slurm job id
    # so we just use a regex to get the number that is in the string
    all_numbers = re.findall("\d+", str(stdout))
    print(all_numbers)
    job_id = all_numbers[0]
    dependency_string = '--dependency=afterok:' + job_id
'''


#----------------------------------------------------------phase2_11_generate_city_center_masks.py

'''
#this script runs on all, u dont need to pass in iata one at a time

workdir = "/caldera/projects/usgs/eros/urban_heat_islands/Phase1/"

some_command = 'srun /home/rhussain/miniconda3/envs/uhi_env/bin/python /home/rhussain/urban-heat-islands-phase2/phase2_11_generate_city_center_masks.py --phase_1_directory ' + str(workdir) + ' --iata_location_identifier ' + str(iata_code)

print(some_command)
# print(os.system("ls"))
# https://cmdlinetips.com/2014/03/how-to-run-a-shell-command-from-python-and-get-the-output/
out = subprocess.Popen(
['sbatch', '--job-name=phase2_11_generate_city_center_masks',
'--output=phase2_11_generate_city_center_masks'+iata_code+'.output',
'--account=eros',
'--partition=workq',
'--nodes=1',
'--ntasks=1',
'--cpus-per-task=40',
'--time=2-00:00:00',  # hpc limit is 2 days if u really need it
'--mail-type=ALL',
'--mail-user=rhussain@contractor.usgs.gov',
'--wrap=' + some_command + '',
],
stdout=subprocess.PIPE,
stderr=subprocess.STDOUT)
stdout, stderr = out.communicate()
print(subprocess.list2cmdline(out.args))
print(stdout)
# https://stackoverflow.com/questions/26825729/extract-number-from-string-in-python/26825781
# basically when u submit a slurm job,
# it returns a string that has one number in it, which is the slurm job id
# so we just use a regex to get the number that is in the string
all_numbers = re.findall("\d+", str(stdout))
print(all_numbers)
job_id = all_numbers[0]
dependency_string = '--dependency=afterok:' + job_id
'''