

#https://stackoverflow.com/questions/16091904/how-to-eliminate-absolute-path-in-zip-archive-if-absolute-paths-for-files-are-pr

import shutil
import os
import argparse
from zipfile import ZipFile
import glob

def zip_folder_and_iata(folder_path,iata_code):
    # https://stackabuse.com/command-line-arguments-in-python/

    # parser = argparse.ArgumentParser()
    # parser.add_argument("--workdir", "-a", help="specify workpath directory")
    # parser.add_argument("--iata_code", "-b", help="iata_code")
    # args = parser.parse_args()
    # iata_code = args.iata_code
    # workdir = args.workdir

    #workdir = "/caldera/projects/usgs/eros/urban_heat_islands/Phase1/FSD/output_folder"
    #iata_code = "FSD"
    workdir = folder_path
    base_path = os.path.join(workdir,iata_code+"_zipped")

    if os.path.exists(base_path):
        shutil.rmtree(base_path)
    if not os.path.exists(base_path):
        os.mkdir(base_path)


    # output filenames as outlined in https://landsat.usgs.gov/jira/browse/LSRD-7862
    # UHI\doc\word\ScienceBase\The_ScienceBase_5.1.1.0\SUHI_Main\Document_5.1.1.0\SUHI Science Base Releasing Structure_final
    #
    # /caldera/projects/usgs/eros/urban_heat_islands/Phase1/FSD/output_folder/INTENSITY_ANNUAL
    # SUHI_CU_xxx_1985_2020_CO1_ANNUAL_MAXLST_INTENSITY.zip
    # SUHI_CU_xxx_1985_2020_CO1_ANNUAL_MEANLST_INTENSITY.zip

    relevant_folder = "INTENSITY_ANNUAL"
    zip_file_name = "SUHI_CU_"+iata_code+"_1985_2020_CO1_ANNUAL_MAXLST_INTENSITY.zip"
    folder_regex = "*MAXLST*"
    full_zip_path = os.path.join(base_path,zip_file_name)
    with ZipFile(full_zip_path,"w") as new_zip:
        full_folder_path = workdir + os.sep + relevant_folder + os.sep
        matching_file_paths = glob.glob(full_folder_path + folder_regex)
        for matching_file_path in matching_file_paths:
            #filename = matching_file_path.split("/")[-1]
            filename = os.path.split(matching_file_path)[-1]
            filename = filename.replace("UHI","SUHI")
            new_zip.write(matching_file_path,arcname=filename)

    relevant_folder = "INTENSITY_ANNUAL"
    zip_file_name = "SUHI_CU_"+iata_code+"_1985_2020_CO1_ANNUAL_MEANLST_INTENSITY.zip"
    folder_regex = "*MEANLST*"
    full_zip_path = os.path.join(base_path,zip_file_name)
    with ZipFile(full_zip_path,"w") as new_zip:
        full_folder_path = workdir + os.sep + relevant_folder + os.sep
        matching_file_paths = glob.glob(full_folder_path + folder_regex)
        for matching_file_path in matching_file_paths:
            #filename = matching_file_path.split("/")[-1]
            filename = os.path.split(matching_file_path)[-1]
            filename = filename.replace("UHI","SUHI")
            new_zip.write(matching_file_path,arcname=filename)

    # Hua said they dont need these
    # # /caldera/projects/usgs/eros/urban_heat_islands/Phase1/FSD/output_folder/ANNUAL
    # # UHI_CU_xxx_1985_2020_CO1_ANNUAL_MAXLST.zip
    # # UHI_CU_xxx_1985_2020_CO1_ANNUAL_MEANLST.zip
    # relevant_folder = "ANNUAL"
    # zip_file_name = "UHI_CU_"+iata_code+"_1985_2020_CO1_ANNUAL_MAXLST.zip"
    # folder_regex = "*MAXLST*"
    # full_zip_path = os.path.join(base_path,zip_file_name)
    # with ZipFile(full_zip_path,"w") as new_zip:
    #     full_folder_path = workdir + os.sep + relevant_folder + os.sep
    #     matching_file_paths = glob.glob(full_folder_path + folder_regex)
    #     for matching_file_path in matching_file_paths:
    #         new_zip.write(matching_file_path)

    # relevant_folder = "ANNUAL"
    # zip_file_name = "UHI_CU_"+iata_code+"_1985_2020_CO1_ANNUAL_MEANLST.zip"
    # folder_regex = "*MEANLST*"
    # full_zip_path = os.path.join(base_path,zip_file_name)
    # with ZipFile(full_zip_path,"w") as new_zip:
    #     full_folder_path = workdir + os.sep + relevant_folder + os.sep
    #     matching_file_paths = glob.glob(full_folder_path + folder_regex)
    #     for matching_file_path in matching_file_paths:
    #         new_zip.write(matching_file_path)


    # /caldera/projects/usgs/eros/urban_heat_islands/Phase1/FSD/output_folder/HOTSPOT
    # SUHI_CU_xxx_1985_2020_CO1_Hospots_urban(MaxLST).zip
    # SUHI_CU_xxx_1985_2020_CO1_Hospots_urban(MeanLST).zip

    #PROBABILITY_PU + PROBABILITY_NU
    #its only gonna be two

    relevant_folder = "HOTSPOT_PROBABILITY"
    zip_file_name = "SUHI_CU_"+iata_code+"_1985_2020_CO1_Hotspots_urban(MaxLST).zip"
    folder_regex = "*MAXLST_HOTSPOT_PROBABILITY_*"
    full_zip_path = os.path.join(base_path,zip_file_name)
    with ZipFile(full_zip_path,"w") as new_zip:
        full_folder_path = workdir + os.sep + relevant_folder + os.sep
        matching_file_paths = glob.glob(full_folder_path + folder_regex)
        for matching_file_path in matching_file_paths:
            #filename = matching_file_path.split("/")[-1]
            filename = os.path.split(matching_file_path)[-1]
            filename = filename.replace("UHI","SUHI")
            new_zip.write(matching_file_path,arcname=filename)
        

    relevant_folder = "HOTSPOT_PROBABILITY"
    zip_file_name = "SUHI_CU_"+iata_code+"_1985_2020_CO1_Hotspots_urban(MeanLST).zip"
    folder_regex = "*MEANLST_HOTSPOT_PROBABILITY_*"
    full_zip_path = os.path.join(base_path,zip_file_name)
    with ZipFile(full_zip_path,"w") as new_zip:
        full_folder_path = workdir + os.sep + relevant_folder + os.sep
        matching_file_paths = glob.glob(full_folder_path + folder_regex)
        for matching_file_path in matching_file_paths:
            #filename = matching_file_path.split("/")[-1]
            filename = os.path.split(matching_file_path)[-1]
            filename = filename.replace("UHI","SUHI")
            new_zip.write(matching_file_path,arcname=filename)


    #/caldera/projects/usgs/eros/urban_heat_islands/Phase1/FSD/output_folder/UrbanZones/FSD_sep
    relevant_folder = "UrbanZones"
    zip_file_name = iata_code+"UrbanZones.zip"
    folder_regex = "*.tif"
    full_zip_path = os.path.join(base_path,zip_file_name)
    with ZipFile(full_zip_path,"w") as new_zip:
        full_folder_path = workdir + os.sep + relevant_folder + os.sep
        matching_file_paths = glob.glob(full_folder_path + folder_regex)
        for matching_file_path in matching_file_paths:
            #filename = matching_file_path.split("/")[-1]
            filename = os.path.split(matching_file_path)[-1]
            filename = filename.replace("uhi","suhi")
            new_zip.write(matching_file_path,arcname=filename)

    print("done")



if __name__ == '__main__':

    #workdir = "/caldera/projects/usgs/eros/urban_heat_islands/Phase1/"+iata_code+"/output_folder"

    # iatas_todo = ["DEN", "LIT", "BNA", "PDX", "MIA", "SMF", "COS", "ELP", "MEM", "SAN", "BOS", "SLC", "RDU", "LUK", "ABQ", "LAX", "LGA", "AUS", 
    #                "MCI", "CYS", "PHL"]

    iatas_todo = ["DCA"]

    #iatas_todo = ["ABQ"]

    for some_iata_code in iatas_todo:
        workdir = "/caldera/projects/usgs/eros/urban_heat_islands/Phase1/"+some_iata_code+"/output_folder"
        zip_folder_and_iata(workdir,some_iata_code)

    
    