

import fiona
import rasterio
from rasterio import features
from rasterio.merge import merge
import os


def rasterize_shapefile(input_raster_path,input_shapefile_path,output_raster_file_path):
    src = rasterio.open(input_raster_path)
    loaded_shapefile = fiona.open(input_shapefile_path)
    geometry_value_pair_tuples_list = []
    for row in loaded_shapefile:
        g = row["geometry"]
        v = row["properties"]["UHI_ID"]
        #https://stackoverflow.com/questions/18667410/how-to-check-if-a-string-only-contains-letters
        v_fixed = ''.join(ch for ch in v if not ch.isalpha())
        geometry_value_pair_tuples_list.append((g,int(v_fixed)))
    image = rasterio.features.rasterize(geometry_value_pair_tuples_list,out_shape=src.shape,transform=src.transform)
    with rasterio.open(
            output_raster_file_path,'w',
            driver='GTiff',
            dtype=rasterio.uint16,
            count=1,
            width=src.width,
            height=src.height,
            transform=src.transform) as dst:
        dst.write(image, indexes=1)



#all_iata_codes = ["FSD","MSO","ORD","MKE","PHX","RDU","FAR","LIT","PIT","SDF","CYS","BOI","MSP","OMA","ABQ","LAS","DTW","BOS","OKC","MEM","BNA","ELP","DEN","IND","SFO","ATL","CMH","DFW","SAT","PHL","DSM","JAX","IAH","LAX","LGA","BHX","MSY","MIA","BWI","SLC","PHX","CVG","CLT","SMF","SEA","MCI","PDX","COS","SAN","AUS","DCA"]
iata_codes_uppercase = ["FSD","MSO"]
src_files_to_mosaic = []
for iata_code in iata_codes_uppercase:
    print(iata_code)

    rasters_folder_path = "/caldera/projects/usgs/eros/urban_heat_islands/Phase1/"+iata_code+"/output_folder/LST_CLASS_STATS_ANNUAL/ByCityCenter"
    first_raster_filename = os.listdir(rasters_folder_path)[0]

    input_raster_path = os.path.join(rasters_folder_path,first_raster_filename)
    input_shapefile_path = "/caldera/projects/usgs/eros/urban_heat_islands/Phase2/uhi_metrobuffer_generation/City_Boundaries_Dissolved/ard_"+iata_code.lower()+"_city_dissolved.shp"
    output_raster_file_path = '/caldera/projects/usgs/eros/urban_heat_islands/Phase2/uhi_generate_city_center_masks/temp/'+iata_code+'.tif'

    src_files_to_mosaic.append(output_raster_file_path)

    rasterize_shapefile(input_raster_path,input_shapefile_path,output_raster_file_path)


# now need to mosaic them
# https://gist.github.com/nishadhka/9bc758129c2949a3194b79570198f544

file_for_meta = rasterio.open(output_raster_file_path)

mosaic, out_trans = merge(src_files_to_mosaic)
out_meta = file_for_meta.meta.copy()
out_meta.update({"driver": "GTiff",
                    "height": mosaic.shape[1],
                    "width": mosaic.shape[2],
                    "transform": out_trans
                    })

output_path = '/caldera/projects/usgs/eros/urban_heat_islands/Phase2/uhi_generate_city_center_masks/city_center_masks_raster_merged.tif'
with rasterio.open(output_path, "w", **out_meta) as dest:
    dest.write(mosaic)

ABC = None





















    


"""

    src_files_to_mosaic_cc = []

    for ccraster in mosaic_list_cc:
        #print(ccraster)
        src_cc = rasterio.open(ccraster)
        print(src_cc)
        src_files_to_mosaic_cc.append(src_cc)

    #print(src_files_to_mosaic_cc)

    mosaic_cc, out_trans_cc = merge(src_files_to_mosaic_cc)

"""

#image = rasterio.features.rasterize(((g,v) for g,v in geometry_value_pair_tuples_list),out_shape=src.shape)
#image = rasterio.features.rasterize(((g,v) for g,v in geometry_value_pair_tuples_list),out_shape=src.shape)
#'C:\\Users\\rhussain\\OneDrive - DOI\\Desktop\\all_pycharm_projects\\uhi_resources\\rasterized-results.tif', 'w',
#rasters_path = "/caldera/projects/usgs/eros/urban_heat_islands/Phase1/FSD/output_folder/LST_CLASS_STATS_ANNUAL/ByCityCenter"
