
import fsspec
import os

from ceph.cp import c2_prefix_info
from cytoolz import thread_first


def ceph(fs: fsspec.AbstractFileSystem, product_list: list[dict], **kwargs) -> list[dict]:
    return thread_first(
        lambda x: not fs.exists(c2_prefix_info(x["entityId"])[-1]),
        (filter, product_list),
        list
    )


def local(fs: fsspec.AbstractFileSystem, product_list: list[dict], outroot: str) -> list[dict]:
    return thread_first(
        lambda x: not fs.exists(os.path.join(outroot, x["entityId"])),
        (filter, product_list),
        list
    )
