
import fsspec

from m2m import stdout_logger

logger = stdout_logger(__name__)


def local(**kwargs) -> fsspec.AbstractFileSystem:
    """Instantiate an abstracted local filesystem interface."""
    return fsspec.filesystem("file")


def ceph(**kwargs) -> fsspec.AbstractFileSystem:
    """Instantiate a S3FS interface for Ceph."""
    kwargs["client_kwargs"] = {"endpoint_url": kwargs.pop("endpoint_url")}
    return fsspec.filesystem("s3", **kwargs)
