
import fsspec
import os
import requests

from ceph.cp import c2_prefix_info
from m2m.api import retry


@retry(10)
def rget(url):
    resp = requests.get(url, timeout=1200)
    return resp


def _src_file(url: str):
    return url.split("/")[-1].split("?")[0]


def _download(url: str, fs: fsspec.AbstractFileSystem, outfile: str) -> int:
    resp = rget(url)
    with fs.open(outfile, 'wb') as of:
        of.write(resp.content)

    return int(resp.headers['Content-Length'])


def ceph(url: str, **kwargs) -> int:
    _, outfile = c2_prefix_info(_src_file(url))
    fs = kwargs.pop("fs")
    return _download(url, fs=fs, outfile=outfile)


def local(url: str, **kwargs) -> int:
    outfile = os.path.join(kwargs.pop("outroot"),
                           _src_file(url))
    fs = kwargs.pop("fs")
    return _download(url, fs=fs, outfile=outfile)
