"""M2M module"""
import logging
import sys


def stdout_logger(
    name: str, level: int=logging.INFO, log_format: str="[%(levelname)s] - %(asctime)s - %(message)s", datefmt: str="%Y-%m-%d %H:%M:%S"
) -> logging.Logger:
    """Setup logging with stdout."""
    logger = logging.Logger(name)
    logger.setLevel(level)
    handler = logging.StreamHandler(sys.stdout)
    formatter = logging.Formatter(fmt=log_format, datefmt=datefmt)
    handler.setFormatter(formatter)
    logger.addHandler(handler)
    return logger
