
import scripts_m2m_download_new_modified2 as m2m
import argparse
import os
import traceback
import time

if __name__ == '__main__':
    #https://stackabuse.com/command-line-arguments-in-python/
    parser = argparse.ArgumentParser()
    #(workpath,HV_List,start_year_inclusive,end_year_inclusive)
    parser.add_argument("--workpath", "-w", help="specify workpath directory")
    parser.add_argument("--hv_tilelist", "-t", help="specify comma delimited ard tile names")
    parser.add_argument("--start_year_inclusive", "-s", help="specify start_year_inclusive")
    parser.add_argument("--end_year_inclusive", "-e", help="specify end_year_inclusive")
    parser.add_argument("--username", "-u", help="earth explorer account m2m username")
    parser.add_argument("--password", "-p", help="earth explorer account m2m password")

    # Read arguments from the command line
    args = parser.parse_args()

    if args.workpath and args.start_year_inclusive and args.end_year_inclusive and args.hv_tilelist and args.username and args.password:
        #parse the hv_tilelist here
        hv_tilelist = args.hv_tilelist.split(",")#convert the str to a list
        print(str(args))
        a_start_year_inclusive = int(args.start_year_inclusive)
        a_end_year_inclusive = int(args.end_year_inclusive)
        tile_hv_names_to_match = hv_tilelist
        base_dir = args.workpath
        username = args.username
        password = args.password

        for a_tile_hv_name in tile_hv_names_to_match:
            some_h = int(a_tile_hv_name[1:3])
            some_v = int(a_tile_hv_name[4:6])
            destination_folder = base_dir+"/"+a_tile_hv_name
            if not os.path.isdir(destination_folder):
                os.mkdir(destination_folder)
            for current_year in range(a_start_year_inclusive,a_end_year_inclusive+1):
                acq_date = str(current_year)+"-1-1,"+str(current_year)+"-12-31"
                #m2m times out if you use more than 1 thread sometimes
                succeeded = False
                tries = 0
                while not succeeded:
                    try:
                        # m2m.download_files(directory=destination_folder, h=some_h, v=some_v, acq_date=acq_date,
                        #                    threads=1,
                        #                    username=username, password=password, dataset="ARD_TILE",
                        #                    products="ST", spacecraft="LANDSAT_4")
                        # m2m.download_files(directory=destination_folder, h=some_h, v=some_v, acq_date=acq_date,
                        #                    threads=1,
                        #                    username=username, password=password, dataset="ARD_TILE",
                        #                    products="ST", spacecraft="LANDSAT_5")
                        # m2m.download_files(directory=destination_folder, h=some_h, v=some_v, acq_date=acq_date,
                        #                    threads=1,
                        #                    username=username, password=password, dataset="ARD_TILE",
                        #                    products="ST", spacecraft="LANDSAT_7")
                        # m2m.download_files(directory=destination_folder, h=some_h, v=some_v, acq_date=acq_date,
                        #                    threads=1,
                        #                    username=username, password=password, dataset="ARD_TILE",
                        #                    products="ST", spacecraft="LANDSAT_8")


                        m2m.download_files(directory=destination_folder, h=some_h, v=some_v, acq_date=acq_date,
                                           threads=1,
                                           username=username, password=password, dataset="landsat_ard_tile_c2",
                                           products="ST", spacecraft="LANDSAT_4")
                        m2m.download_files(directory=destination_folder, h=some_h, v=some_v, acq_date=acq_date,
                                           threads=1,
                                           username=username, password=password, dataset="landsat_ard_tile_c2",
                                           products="ST", spacecraft="LANDSAT_5")
                        m2m.download_files(directory=destination_folder, h=some_h, v=some_v, acq_date=acq_date,
                                           threads=1,
                                           username=username, password=password, dataset="landsat_ard_tile_c2",
                                           products="ST", spacecraft="LANDSAT_7")
                        m2m.download_files(directory=destination_folder, h=some_h, v=some_v, acq_date=acq_date,
                                           threads=1,
                                           username=username, password=password, dataset="landsat_ard_tile_c2",
                                           products="ST", spacecraft="LANDSAT_8")

                        
                        succeeded = True
                    except Exception as e:
                        print("exception")
                        print(str(e))
                        traceback.print_exc()
                        time.sleep(1)
        print("finished download step")
