#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Fri Jun 13 14:34:18 2025

@author: mlubke
"""

#%% Library Loading Section

import os
import pandas as pd
from glob import glob


#%% Environment Variables

iata = "BSB"

#csv_dir = 'W:/UHI/CGI/analysis/wuh/results/INTENSITY_CLASS_STATS_ANNUAL/LST_CLASS_STATS_ANNUAL/ByCSV'
csv_dir = f'W:/UHI/data/CGI/{iata}/INTENSITY_CLASS_STATS_ANNUAL/LST_CLASS_STATS_ANNUAL/ByCSV'
#out_dir = 'V:/UHI/CGI/analysis/wuh/csv/intensity'
out_dir = f'W:/UHI/data/CGI/{iata}/csv/intensity'
#os.makedirs(out_dir)

station_list = ['ByCSV']



# For development and testing
#station = 'ByCSV_BSB'

#%% Main routine

for station in station_list:
    
    # Start a new dataframe for each station
    df = pd.DataFrame()
    
    # Create the output file name based on the station
    #station_name = station.split('_')[1]
    csv_out = os.path.join(out_dir, f'{"output_csv"}.csv')
    
    # Where the csv files are located for each station
    station_dir = os.path.join(csv_dir, station)
    
    # Read all csv files into a list
    csv_files = glob(os.path.join(csv_dir, '*.csv'))
    
    
    # Iterate on the list of csv files
    for csv_file in csv_files:
        
        # Get the year and lst_type by parsing each csv_filename
        csv_filename = os.path.basename(csv_file)
        
        year = int(csv_filename.split('_')[3])
        lst_type = csv_filename.split('_')[6]
        
        
        # Read csv file into a temporary dataframe
        df_tmp = pd.read_csv(csv_file)
        
        # Create columns for the year and type
        df_tmp['year'] = year
        df_tmp['lst_type'] = lst_type
        
        # Only grab mean and standard deviation for classes 1 and 2
        df_tmp = df_tmp.loc[(df_tmp['class'] > 0)][['year','lst_type','class','mean','sd']]
        
        
        # Concat the temporary dataframe to the output dataframe
        df = pd.concat([df, df_tmp], ignore_index=True)
        
    
    # After iterating on all csv files, write out the dataframe to a csv file
    df.to_csv(csv_out, header=True, index=False)
